/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public final class ScalingExecutorBuilder
extends ExecutorBuilder<ScalingExecutorSettings> {
    private final Setting<Integer> coreSetting;
    private final Setting<Integer> maxSetting;
    private final Setting<TimeValue> keepAliveSetting;

    public ScalingExecutorBuilder(String name, int core, int max, TimeValue keepAlive) {
        this(name, core, max, keepAlive, "thread_pool." + name);
    }

    public ScalingExecutorBuilder(String name, int core, int max, TimeValue keepAlive, String prefix) {
        super(name);
        this.coreSetting = Setting.intSetting(ScalingExecutorBuilder.settingsKey(prefix, "core"), core, Setting.Property.NodeScope);
        this.maxSetting = Setting.intSetting(ScalingExecutorBuilder.settingsKey(prefix, "max"), max, Setting.Property.NodeScope);
        this.keepAliveSetting = Setting.timeSetting(ScalingExecutorBuilder.settingsKey(prefix, "keep_alive"), keepAlive, Setting.Property.NodeScope);
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.coreSetting, this.maxSetting, this.keepAliveSetting);
    }

    @Override
    ScalingExecutorSettings getSettings(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int coreThreads = this.coreSetting.get(settings);
        int maxThreads = this.maxSetting.get(settings);
        TimeValue keepAlive = this.keepAliveSetting.get(settings);
        return new ScalingExecutorSettings(nodeName, coreThreads, maxThreads, keepAlive);
    }

    @Override
    ThreadPool.ExecutorHolder build(ScalingExecutorSettings settings, ThreadContext threadContext) {
        TimeValue keepAlive = settings.keepAlive;
        int core = settings.core;
        int max = settings.max;
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.SCALING, core, max, keepAlive, null);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings.nodeName, this.name()));
        EsThreadPoolExecutor executor = EsExecutors.newScaling(settings.nodeName + "/" + this.name(), core, max, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory, threadContext);
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], core [%d], max [%d], keep alive [%s]", info.getName(), info.getMin(), info.getMax(), info.getKeepAlive());
    }

    static class ScalingExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        private final int core;
        private final int max;
        private final TimeValue keepAlive;

        ScalingExecutorSettings(String nodeName, int core, int max, TimeValue keepAlive) {
            super(nodeName);
            this.core = core;
            this.max = max;
            this.keepAlive = keepAlive;
        }
    }
}

