/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.jackson;

import ch.qos.logback.contrib.json.JsonFormatter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class JacksonJsonFormatter
implements JsonFormatter {
    public static final int BUFFER_SIZE = 512;
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean prettyPrint = false;

    @Override
    public String toJsonString(Map map) throws IOException {
        StringWriter stringWriter = new StringWriter(512);
        JsonGenerator jsonGenerator = this.objectMapper.getFactory().createJsonGenerator((Writer)stringWriter);
        if (this.isPrettyPrint()) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        this.objectMapper.writeValue(jsonGenerator, (Object)map);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }
}

