/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import javax.xml.validation.SchemaFactory;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.validator.DefaultValidatorResourceResolverFactory;
import org.apache.camel.component.validator.ValidatorProducer;
import org.apache.camel.component.validator.ValidatorResourceResolverFactory;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.SchemaReader;
import org.apache.camel.processor.validation.ValidatingProcessor;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.w3c.dom.ls.LSResourceResolver;

@ManagedResource(description="Managed ValidatorEndpoint")
@UriEndpoint(firstVersion="1.1.0", scheme="validator", title="Validator", syntax="validator:resourceUri", producerOnly=true, label="core,validation")
public class ValidatorEndpoint
extends DefaultEndpoint {
    @UriPath(description="URL to a local resource on the classpath, or a reference to lookup a bean in the Registry, or a full URL to a remote resource or resource on the file system which contains the XSD to validate against.")
    @Metadata(required="true")
    private String resourceUri;
    @UriParam(defaultValue="http://www.w3.org/2001/XMLSchema", label="advanced", description="Configures the W3C XML Schema Namespace URI.")
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    @UriParam(label="advanced", description="To use a custom javax.xml.validation.SchemaFactory")
    private SchemaFactory schemaFactory;
    @UriParam(label="advanced", description="To use a custom org.apache.camel.processor.validation.ValidatorErrorHandler. The default error handler captures the errors and throws an exception.")
    private ValidatorErrorHandler errorHandler = new DefaultValidationErrorHandler();
    @UriParam(label="advanced", description="Whether DOMSource/DOMResult or SaxSource/SaxResult should be used by the validator.")
    private boolean useDom;
    @UriParam(defaultValue="true", label="advanced", description="Whether the Schema instance should be shared or not. This option is introduced to work around a JDK 1.6.x bug. Xerces should not have this issue.")
    private boolean useSharedSchema = true;
    @UriParam(label="advanced", description="To use a custom LSResourceResolver.  Do not use together with resourceResolverFactory")
    private LSResourceResolver resourceResolver;
    @UriParam(label="advanced", description="To use a custom LSResourceResolver which depends on a dynamic endpoint resource URI. The default resource resolver factory resturns a resource resolver which can read files from the class path and file system. Do not use together with resourceResolver.")
    private ValidatorResourceResolverFactory resourceResolverFactory;
    @UriParam(defaultValue="true", description="Whether to fail if no body exists.")
    private boolean failOnNullBody = true;
    @UriParam(defaultValue="true", description="Whether to fail if no header exists when validating against a header.")
    private boolean failOnNullHeader = true;
    @UriParam(description="To validate against a header instead of the message body.")
    private String headerName;
    private final SchemaReader schemaReader;
    private volatile boolean schemaReaderConfigured;

    public ValidatorEndpoint() {
        this.schemaReader = new SchemaReader();
    }

    public ValidatorEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component);
        this.resourceUri = resourceUri;
        this.schemaReader = new SchemaReader(this.getCamelContext(), resourceUri);
    }

    @ManagedOperation(description="Clears the cached schema, forcing to re-load the schema on next request")
    public void clearCachedSchema() {
        this.schemaReader.setSchema(null);
    }

    @Override
    public Producer createProducer() throws Exception {
        if (!this.schemaReaderConfigured) {
            if (this.resourceResolver != null) {
                this.schemaReader.setResourceResolver(this.resourceResolver);
            } else if (this.resourceResolverFactory != null) {
                this.resourceResolver = this.resourceResolverFactory.createResourceResolver(this.getCamelContext(), this.resourceUri);
                this.schemaReader.setResourceResolver(this.resourceResolver);
            } else {
                this.schemaReader.setResourceResolver(new DefaultValidatorResourceResolverFactory().createResourceResolver(this.getCamelContext(), this.resourceUri));
            }
            this.schemaReader.setSchemaLanguage(this.getSchemaLanguage());
            this.schemaReader.setSchemaFactory(this.getSchemaFactory());
            this.schemaReader.loadSchema();
            this.schemaReaderConfigured = true;
        }
        ValidatingProcessor validator = new ValidatingProcessor(this.schemaReader);
        this.configureValidator(validator);
        return new ValidatorProducer(this, validator);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from validator");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected void configureValidator(ValidatingProcessor validator) throws Exception {
        validator.setErrorHandler(this.getErrorHandler());
        validator.setUseDom(this.isUseDom());
        validator.setUseSharedSchema(this.isUseSharedSchema());
        validator.setFailOnNullBody(this.isFailOnNullBody());
        validator.setFailOnNullHeader(this.isFailOnNullHeader());
        validator.setHeaderName(this.getHeaderName());
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public ValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isUseDom() {
        return this.useDom;
    }

    public void setUseDom(boolean useDom) {
        this.useDom = useDom;
    }

    public boolean isUseSharedSchema() {
        return this.useSharedSchema;
    }

    public void setUseSharedSchema(boolean useSharedSchema) {
        this.useSharedSchema = useSharedSchema;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public ValidatorResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    public void setResourceResolverFactory(ValidatorResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    public boolean isFailOnNullHeader() {
        return this.failOnNullHeader;
    }

    public void setFailOnNullHeader(boolean failOnNullHeader) {
        this.failOnNullHeader = failOnNullHeader;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

