/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.lp2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.learner.lp2.LP2Rule;

public class LP2CurrentBestRulesQueue
implements Iterable<LP2Rule> {
    private PriorityQueue<LP2Rule> ruleList;
    private PriorityQueue<LP2Rule> reverseRuleList;
    private int maxSize;

    private static int cmpRules(LP2Rule o1, LP2Rule o2) {
        int c2;
        if (o1.getCoveringStatistics().getCoveredPositivesCount() > o2.getCoveringStatistics().getCoveredPositivesCount()) {
            return -1;
        }
        if (o1.getCoveringStatistics().getCoveredPositivesCount() < o2.getCoveringStatistics().getCoveredPositivesCount()) {
            return 1;
        }
        if (o1.getErrorRate() < o2.getErrorRate()) {
            return -1;
        }
        if (o1.getErrorRate() > o2.getErrorRate()) {
            return 1;
        }
        int c1 = o1.totalConstraintCount();
        if (c1 < (c2 = o2.totalConstraintCount())) {
            return -1;
        }
        if (c1 > c2) {
            return 1;
        }
        return o1.getRuleString().compareTo(o2.getRuleString());
    }

    public LP2CurrentBestRulesQueue(int maxSize) {
        this.maxSize = Math.max(1, maxSize);
        this.ruleList = new PriorityQueue<LP2Rule>(this.maxSize, new Comparator<LP2Rule>(){

            @Override
            public int compare(LP2Rule o1, LP2Rule o2) {
                return LP2CurrentBestRulesQueue.cmpRules(o1, o2);
            }
        });
        this.reverseRuleList = new PriorityQueue<LP2Rule>(this.maxSize, new Comparator<LP2Rule>(){

            @Override
            public int compare(LP2Rule o1, LP2Rule o2) {
                return -LP2CurrentBestRulesQueue.cmpRules(o1, o2);
            }
        });
    }

    @Override
    public Iterator<LP2Rule> iterator() {
        return this.ruleList.iterator();
    }

    public void clear() {
        this.ruleList.clear();
        this.reverseRuleList.clear();
    }

    public void addAll(Collection<LP2Rule> rules) {
        for (LP2Rule r : rules) {
            this.add(r);
        }
    }

    public void add(LP2Rule rule) {
        this.ruleList.add(rule);
        this.reverseRuleList.add(rule);
    }

    public boolean contains(LP2Rule rule) {
        return this.ruleList.contains(rule);
    }

    public Collection<LP2Rule> cutToMaxSize() {
        ArrayList<LP2Rule> result = new ArrayList<LP2Rule>();
        while (this.ruleList.size() > this.maxSize) {
            LP2Rule tail = this.reverseRuleList.peek();
            this.ruleList.remove(tail);
            this.reverseRuleList.remove(tail);
            result.add(tail);
        }
        return result;
    }

    public LP2Rule peek() {
        return this.ruleList.peek();
    }

    public void remove(LP2Rule r) {
        this.ruleList.remove(r);
        this.reverseRuleList.remove(r);
    }

    public LP2Rule[] toArray() {
        LP2Rule[] result = new LP2Rule[this.ruleList.size()];
        int i = 0;
        Iterator<LP2Rule> i$ = this.ruleList.iterator();
        while (i$.hasNext()) {
            LP2Rule r;
            result[i] = r = i$.next();
            ++i;
        }
        return result;
    }

    protected void removeSubsumedRules() {
        ArrayList<LP2Rule> removeList = new ArrayList<LP2Rule>();
        LP2Rule[] rulesArray = this.toArray();
        for (int index1 = 0; index1 < rulesArray.length - 1; ++index1) {
            LP2Rule rule1 = rulesArray[index1];
            for (int index2 = index1 + 1; index2 < rulesArray.length; ++index2) {
                LP2Rule rule2 = rulesArray[index2];
                if (!rule1.getCoveringStatistics().getCoveredPositiveExamples().containsAll(rule2.getCoveringStatistics().getCoveredPositiveExamples())) continue;
                removeList.add(rule2);
            }
        }
        for (LP2Rule r : removeList) {
            this.remove(r);
        }
    }

    public void printDebug() {
        TextRulerToolkit.log("-------CURRENT BEST RULES:");
        for (LP2Rule r : this.ruleList) {
            TextRulerToolkit.log(r.getRuleString() + " " + r.getCoveringStatistics() + "  error=" + r.getErrorRate() + "  constraints=" + r.totalConstraintCount());
        }
    }

    public int size() {
        return this.ruleList.size();
    }
}

