/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.preferences;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.extension.TextRulerController;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerController;
import org.apache.uima.ruta.textruler.preferences.TextRulerPreferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class TextRulerPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = TextRulerPlugin.getDefault().getPreferenceStore();
        store.setDefault(TextRulerPreferences.REMOVE_BASICS, true);
        store.setDefault(TextRulerPreferences.LOW_MEMORY_PROFILE, false);
        store.setDefault(TextRulerPreferences.MAX_ERROR_RATE, 10);
        store.setDefault(TextRulerPreferences.CAS_CACHE, 50);
        ArrayList<TextRulerLearnerController> availableControllers = TextRulerController.getAvailableControllers();
        for (TextRulerLearnerController each : availableControllers) {
            String id = each.getID();
            Map<String, Object> defaultValues = each.getFactory().getAlgorithmParameterStandardValues();
            Set<Map.Entry<String, Object>> entrySet = defaultValues.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = id + "." + entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Integer) {
                    store.setDefault(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    store.setDefault(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Float) {
                    store.setDefault(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    store.setDefault(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                store.setDefault(key, (String)value);
            }
        }
    }
}

