/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic;

import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractDynamicModelManager
extends AbstractManager
implements DynamicModelManager {
    @Override
    public synchronized void revokeAll(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        permissionExists = this.getPermissionManager().checkExists(permission);
        if (permissionExists) {
            Object[] roles;
            for (Object role2 : roles = ((DynamicPermission)permission).getRoles().toArray()) {
                this.revoke((Role)role2, permission);
            }
            return;
        }
        throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
    }

    @Override
    public synchronized void revokeAll(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        groupExists = this.getGroupManager().checkExists(group);
        if (groupExists) {
            Object[] roles;
            Object[] users;
            for (Object user : users = ((DynamicGroup)group).getUsers().toArray()) {
                this.revoke((User)user, group);
            }
            for (Object role2 : roles = ((DynamicGroup)group).getRoles().toArray()) {
                this.revoke(group, (Role)role2);
            }
            return;
        }
        throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
    }

    @Override
    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.getUserManager().checkExists(user);
        if (userExists) {
            Object[] groups;
            for (Object group : groups = ((DynamicUser)user).getGroups().toArray()) {
                this.revoke(user, (Group)group);
            }
            return;
        }
        throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
    }

    @Override
    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        roleExists = this.getRoleManager().checkExists(role);
        if (roleExists) {
            Object[] permissions;
            Object[] groups;
            for (Object group : groups = ((DynamicRole)role).getGroups().toArray()) {
                this.revoke((Group)group, role);
            }
            for (Object permission : permissions = ((DynamicRole)role).getPermissions().toArray()) {
                this.revoke(role, (Permission)permission);
            }
        } else {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    @Override
    public void addDelegate(User delegator, User delegatee) throws DataBackendException, UnknownEntityException {
        DynamicUser dynamicDelegator = (DynamicUser)delegator;
        DynamicUser dynamicDelegatee = (DynamicUser)delegatee;
        if (!dynamicDelegator.getDelegatees().contains(delegatee) && !dynamicDelegatee.getDelegators().contains(delegator)) {
            dynamicDelegator.getDelegatees().add(dynamicDelegatee);
            dynamicDelegatee.getDelegators().add(dynamicDelegator);
        }
    }

    @Override
    public void removeDelegate(User delegator, User delegatee) throws DataBackendException, UnknownEntityException {
        DynamicUser dynamicDelegator = (DynamicUser)delegator;
        DynamicUser dynamicDelegatee = (DynamicUser)delegatee;
        if (!dynamicDelegator.getDelegatees().contains(dynamicDelegatee)) {
            throw new UnknownEntityException("Tried to remove a delegate that does not exist");
        }
        dynamicDelegator.getDelegatees().remove(dynamicDelegatee);
        dynamicDelegatee.getDelegators().remove(dynamicDelegator);
    }
}

