package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.MappingStrategy;


/**
 * Maps ResultSet rows into TorqueDynamicGroup objects.
 *
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Jan 03 13:59:33 CET 2025]
 *
 */
@SuppressWarnings("unused")
public class BaseTorqueDynamicGroupRecordMapper implements RecordMapper<TorqueDynamicGroup>
{
    /** Serial version */
    private static final long serialVersionUID = 1735909173196L;

    /** The class log. */
    private static Log log
            = LogFactory.getLog(BaseTorqueDynamicGroupRecordMapper.class);
            
    private static final String GROUP_ID_EXPRESSION = BaseTorqueDynamicGroupPeer.GROUP_ID.getSqlExpression();
    private static final String GROUP_NAME_EXPRESSION = BaseTorqueDynamicGroupPeer.GROUP_NAME.getSqlExpression();

    private boolean useMappingStrategy = true;

    private MappingStrategy<TorqueDynamicGroup> strategy;
    
    public void initStrategy()
    {
        this.strategy = new MappingStrategy<TorqueDynamicGroup>();
    }
    

    /**
     * Constructs the object from the current row in the resultSet.
     *
     * @param resultSet the resultSet to operate on, already pointing
     *        to the correct row. Not null.
     * @param offset a possible offset in the columns to be considered
     *        (if previous columns contain other objects),
     *        or 0 for no offset.
     * @param criteria The criteria which created the result set.
     *        If set, the attributes to set in the data object
     *        are determined from the select columns in the criteria;
     *        if no matching column can be found, null is returned.
     *        If not set, all of the table's columns are read from the
     *        result set in the order defined in the table definition.
     *
     * @return the mapped object, not null.
     *
     * @throws TorqueException when reading fields from the RecordSet fails
     *         or if a Criteria is passed which contains select columns other
     *         than the columns in the FULCRUM_DYNAMIC_GROUP table.
     */
    public TorqueDynamicGroup processRow(
                ResultSet resultSet,
                int offset,
                Criteria criteria)
            throws TorqueException
    {
        TorqueDynamicGroup torqueDynamicGroup = new TorqueDynamicGroup();

        try 
        {
            torqueDynamicGroup.setLoading(true);
            if (criteria == null)
            {
                torqueDynamicGroup.setEntityId(
                        getEntityId(resultSet, offset + 1));
                torqueDynamicGroup.setEntityName(
                        getEntityName(resultSet, offset + 2));
            }
            else
            {
                if (useMappingStrategy) {
                    initStrategy();
                }
                // try to get columns to be mapped
                // from criteria's select columns
                int totalOffset = offset + 1;
                List<Column> selectColumns = criteria.getSelectColumns();
                List<Column> columnsWithoutOffset = selectColumns.subList(
                        offset, 
                        selectColumns.size());
                Set<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset)
                {
                    final int nextOffset = totalOffset;                     if (!columnsMapped.contains(GROUP_ID_EXPRESSION ) && GROUP_ID_EXPRESSION.equals(
                            column.getSqlExpression()))
                    {
                        if (useMappingStrategy) 
                        {
                            strategy.addColumn(nextOffset, 
                                (res, inst) -> inst.setEntityId( getEntityId(res, nextOffset)));
                        } else
                        {
                            torqueDynamicGroup.setEntityId( getEntityId(resultSet, totalOffset));
                        }
                        columnsMapped.add( GROUP_ID_EXPRESSION );
                    }
                    else if (!columnsMapped.contains(GROUP_NAME_EXPRESSION ) && GROUP_NAME_EXPRESSION.equals(
                            column.getSqlExpression()))
                    {
                        if (useMappingStrategy) 
                        {
                            strategy.addColumn(nextOffset, 
                                (res, inst) -> inst.setEntityName( getEntityName(res, nextOffset)));
                        } else
                        {
                            torqueDynamicGroup.setEntityName( getEntityName(resultSet, totalOffset));
                        }
                        columnsMapped.add( GROUP_NAME_EXPRESSION );
                    }
                    totalOffset++;
                }
                if (columnsMapped.isEmpty())
                {
                    log.debug("no columns to map found in criteria, "
                        + "returning null");
                    return null;
                }
                if (useMappingStrategy)
                {
                  this.strategy.finish(2, true);
                  this.strategy.execute(resultSet, torqueDynamicGroup);
                }
            }
            torqueDynamicGroup.setNew(false);
            torqueDynamicGroup.setModified(false);
        }
        finally
        {
            torqueDynamicGroup.setLoading(false);
        }
        return torqueDynamicGroup;
    }

    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field entityId in TorqueDynamicGroup.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getEntityId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field entityName in TorqueDynamicGroup.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getEntityName(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }

}
