/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.js;

import wiremock.com.github.jknack.handlebars.HelperRegistry;
import wiremock.com.github.jknack.handlebars.internal.js.RhinoHandlebars;
import wiremock.org.apache.commons.lang3.ClassUtils;
import wiremock.org.apache.commons.lang3.Validate;

public abstract class HandlebarsJs {
    protected final HelperRegistry registry;

    public HandlebarsJs(HelperRegistry helperRegistry) {
        this.registry = Validate.notNull(helperRegistry, "The helper registry is required.", new Object[0]);
    }

    public abstract void registerHelpers(String var1, String var2) throws Exception;

    public static HandlebarsJs create(HelperRegistry helperRegistry) {
        return HandlebarsJs.createRhino(helperRegistry, -1);
    }

    public static HandlebarsJs createRhino(HelperRegistry helperRegistry, int optimizationLevel) {
        try {
            ClassUtils.getClass("org.mozilla.javascript.Context");
            return new RhinoHandlebars(helperRegistry, optimizationLevel);
        }
        catch (Exception ex) {
            return new HandlebarsJs(helperRegistry){

                @Override
                public void registerHelpers(String filename, String source) throws Exception {
                    throw new IllegalStateException("Rhino isn't on the classpath", ex);
                }
            };
        }
    }
}

