/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tools.javadoc.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.annotation.ConfigurationClass;
import org.apache.tez.common.annotation.ConfigurationProperty;
import org.apache.tez.tools.javadoc.model.Config;
import org.apache.tez.tools.javadoc.model.ConfigProperty;
import org.apache.tez.tools.javadoc.util.HtmlWriter;
import org.apache.tez.tools.javadoc.util.XmlWriter;

public final class ConfigStandardDoclet {
    private static final String DEBUG_SWITCH = "-debug";
    private static boolean debugMode = false;

    private ConfigStandardDoclet() {
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    private static void logMessage(String message) {
        if (!debugMode) {
            return;
        }
        System.out.println(message);
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classes;
        String[][] stringArray = root.options();
        int n = stringArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String[] opts;
            for (String opt : opts = stringArray[i]) {
                if (!opt.equals(DEBUG_SWITCH)) continue;
                debugMode = true;
                continue block0;
            }
        }
        ConfigStandardDoclet.logMessage("Running doclet " + ConfigStandardDoclet.class.getSimpleName());
        for (ClassDoc aClass : classes = root.classes()) {
            ConfigStandardDoclet.processDoc(aClass);
        }
        return true;
    }

    private static void processDoc(ClassDoc doc) {
        FieldDoc[] fields;
        ConfigStandardDoclet.logMessage("Parsing : " + doc);
        if (!doc.isClass()) {
            ConfigStandardDoclet.logMessage("Ignoring non-class: " + doc);
            return;
        }
        AnnotationDesc[] annotations = doc.annotations();
        boolean isConfigClass = false;
        String templateName = null;
        for (AnnotationDesc annotationDesc : annotations) {
            ConfigStandardDoclet.logMessage("Checking annotation: " + annotationDesc.annotationType());
            if (!annotationDesc.annotationType().qualifiedTypeName().equals(ConfigurationClass.class.getName())) continue;
            isConfigClass = true;
            AnnotationDesc.ElementValuePair[] elementValuePairArray = annotationDesc.elementValues();
            int n = elementValuePairArray.length;
            for (int i = 0; i < n; ++i) {
                AnnotationDesc.ElementValuePair element = elementValuePairArray[i];
                if (!element.element().name().equals("templateFileName")) continue;
                templateName = ConfigStandardDoclet.stripQuotes(element.value().toString());
            }
            break;
        }
        if (!isConfigClass) {
            ConfigStandardDoclet.logMessage("Ignoring non-config class: " + doc);
            return;
        }
        ConfigStandardDoclet.logMessage("Processing config class: " + doc);
        Config config = new Config(doc.name(), templateName);
        Map<String, ConfigProperty> configProperties = config.configProperties;
        for (FieldDoc field : fields = doc.fields()) {
            AnnotationDesc[] annotationDescs;
            ConfigProperty configProperty;
            String name;
            if (field.isPrivate()) {
                ConfigStandardDoclet.logMessage("Skipping private field: " + field);
                continue;
            }
            if (!field.isStatic()) {
                ConfigStandardDoclet.logMessage("Skipping non-static field: " + field);
                continue;
            }
            if (field.name().endsWith("_PREFIX")) {
                ConfigStandardDoclet.logMessage("Skipping non-config prefix constant field: " + field);
                continue;
            }
            if (field.name().equals("TEZ_SITE_XML")) {
                ConfigStandardDoclet.logMessage("Skipping constant field: " + field);
                continue;
            }
            if (field.name().endsWith("_DEFAULT")) {
                name = field.name().substring(0, field.name().lastIndexOf("_DEFAULT"));
                if (!configProperties.containsKey(name)) {
                    configProperties.put(name, new ConfigProperty());
                }
                configProperty = configProperties.get(name);
                if (field.constantValue() == null) {
                    ConfigStandardDoclet.logMessage("Got null constant value, name=" + name + ", field=" + field.name() + ", val=" + field.constantValueExpression());
                    configProperty.defaultValue = field.constantValueExpression();
                } else {
                    configProperty.defaultValue = field.constantValue().toString();
                }
                configProperty.inferredType = field.type().simpleTypeName();
                if (!name.equals("TEZ_AM_STAGING_DIR") || configProperty.defaultValue == null) continue;
                String defaultValue = configProperty.defaultValue;
                configProperty.defaultValue = defaultValue = defaultValue.replace(System.getProperty("user.name"), "${user.name}");
                continue;
            }
            name = field.name();
            if (!configProperties.containsKey(name)) {
                configProperties.put(name, new ConfigProperty());
            }
            configProperty = configProperties.get(name);
            configProperty.propertyName = field.constantValue().toString();
            for (AnnotationDesc annotationDesc : annotationDescs = field.annotations()) {
                if (annotationDesc.annotationType().qualifiedTypeName().equals(InterfaceAudience.Private.class.getCanonicalName())) {
                    configProperty.isPrivate = true;
                }
                if (annotationDesc.annotationType().qualifiedTypeName().equals(InterfaceStability.Unstable.class.getCanonicalName())) {
                    configProperty.isUnstable = true;
                }
                if (annotationDesc.annotationType().qualifiedTypeName().equals(InterfaceStability.Evolving.class.getCanonicalName())) {
                    configProperty.isEvolving = true;
                }
                if (!annotationDesc.annotationType().qualifiedTypeName().equals(ConfigurationProperty.class.getCanonicalName())) continue;
                configProperty.isValidConfigProp = true;
                for (AnnotationDesc.ElementValuePair element : annotationDesc.elementValues()) {
                    if (element.element().name().equals("type")) {
                        configProperty.type = ConfigStandardDoclet.stripQuotes(element.value().toString());
                        continue;
                    }
                    ConfigStandardDoclet.logMessage("Unhandled annotation property: " + element.element().name());
                }
            }
            configProperty.description = field.commentText();
        }
        HtmlWriter htmlWriter = new HtmlWriter();
        try {
            htmlWriter.write(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        XmlWriter xmlWriter = new XmlWriter();
        try {
            xmlWriter.write(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String stripQuotes(String s) {
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static int optionLength(String option) {
        return Standard.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return true;
    }
}

