-- This test tests CTEs with multi-children operators (Union, Intersect, Except, Join etc).

CREATE TEMPORARY VIEW t1 AS SELECT * FROM VALUES
  ("one", 1), ("two", 2), ("three", 3), ("one", 5) AS t1(col1, col2);

CREATE TEMPORARY VIEW t2 AS SELECT * FROM VALUES
  ("one", 1), ("two", 2), ("three", 3), ("one", 5) AS t1(col1, col2);

-- LEFT JOIN
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
LEFT JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- INNER JOIN
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
INNER JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- RIGHT JOIN
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
RIGHT JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- FULL OUTER JOIN
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
FULL OUTER JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- UNION
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
UNION
SELECT * FROM (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- EXCEPT
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
EXCEPT
SELECT * FROM (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- INTERSECT
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM t1)
INTERSECT
SELECT * FROM (WITH cte AS (SELECT * FROM t2) SELECT * FROM t2);

-- Tests with CTE reference

-- LEFT JOIN with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
LEFT JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);

-- INNER JOIN with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
INNER JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);

-- RIGHT JOIN with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
RIGHT JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);

-- FULL OUTER JOIN with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
FULL OUTER JOIN (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);

-- UNION with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
UNION
SELECT * FROM (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);

-- EXCEPT with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
EXCEPT
SELECT * FROM (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);

-- INTERSECT with CTE reference
SELECT * FROM (WITH cte AS (SELECT * FROM t1) SELECT * FROM cte)
INTERSECT
SELECT * FROM (WITH cte AS (SELECT * FROM t2) SELECT * FROM cte);
