/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.resttemplate.async;

import java.lang.reflect.Method;
import java.net.URI;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.commons.EnhanceCacheObjects;
import org.apache.skywalking.apm.plugin.spring.resttemplate.helper.RestTemplateRuntimeContextHelper;
import org.springframework.http.HttpMethod;

public class RestExecuteInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        URI requestURL = (URI)allArguments[0];
        HttpMethod httpMethod = (HttpMethod)allArguments[1];
        ContextCarrier contextCarrier = new ContextCarrier();
        String remotePeer = requestURL.getHost() + ":" + (requestURL.getPort() > 0 ? requestURL.getPort() : ("https".equalsIgnoreCase(requestURL.getScheme()) ? 443 : 80));
        String uri = requestURL.getPath();
        AbstractSpan span = ContextManager.createExitSpan((String)uri, (ContextCarrier)contextCarrier, (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.SPRING_REST_TEMPLATE);
        Tags.URL.set(span, requestURL.getScheme() + "://" + requestURL.getHost() + (requestURL.getPort() > 0 ? ":" + requestURL.getPort() : "") + requestURL.getPath());
        Tags.HTTP.METHOD.set(span, httpMethod.toString());
        SpanLayer.asHttp((AbstractSpan)span);
        RestTemplateRuntimeContextHelper.addUri(uri);
        RestTemplateRuntimeContextHelper.addContextCarrier(contextCarrier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        try {
            ContextSnapshot contextSnapshot = ContextManager.capture();
            if (ret != null) {
                String uri = RestTemplateRuntimeContextHelper.getUri();
                ((EnhancedInstance)ret).setSkyWalkingDynamicField((Object)new EnhanceCacheObjects(uri, ComponentsDefine.SPRING_REST_TEMPLATE, SpanLayer.HTTP, contextSnapshot));
            }
            ContextManager.stopSpan();
        }
        finally {
            RestTemplateRuntimeContextHelper.cleanUri();
            RestTemplateRuntimeContextHelper.cleanContextCarrier();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

