/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuteExceptionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuteExceptionUtil.class);

    public static MuteExceptionUtilBuilder builder() {
        return new MuteExceptionUtilBuilder();
    }

    public static class MuteExceptionUtilBuilder {
        private String logMessage;
        private Object[] customMessageParams;

        public MuteExceptionUtilBuilder withLog(String message, Object ... params) {
            this.logMessage = message;
            this.customMessageParams = params;
            return this;
        }

        private String getLogMessage(String defaultMessage) {
            return this.logMessage != null ? this.logMessage : defaultMessage;
        }

        public <T, R> R executeFunction(FunctionWithException<T, R> function, T t) {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                LOGGER.error(this.getLogMessage("execute Function failure..."), (Object)this.customMessageParams, (Object)e);
                return null;
            }
        }

        public <T> T executeSupplier(Supplier<T> supplier) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                LOGGER.error(this.getLogMessage("execute Supplier failure..."), (Object)this.customMessageParams, (Object)e);
                return null;
            }
        }

        public <T> T executeCompletableFuture(CompletableFuture<T> completableFuture) {
            try {
                return completableFuture.get();
            }
            catch (Exception e) {
                LOGGER.error(this.getLogMessage("execute CompletableFuture failure..."), (Object)this.customMessageParams, (Object)e);
                return null;
            }
        }

        public <T1, T2, R> R executeFunctionWithDoubleParam(FunctionWithDoubleParam<T1, T2, R> function, T1 t1, T2 t2) {
            try {
                return function.apply(t1, t2);
            }
            catch (Exception e) {
                LOGGER.error(this.getLogMessage("execute FunctionWithDoubleParam failure..."), (Object)this.customMessageParams, (Object)e);
                return null;
            }
        }
    }

    public static interface FunctionWithDoubleParam<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws Exception;
    }

    public static interface FunctionWithException<T, R> {
        public R apply(T var1) throws Exception;
    }
}

