/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.monitor.Monitor;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.servo.DoubleCounter;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

class ServoCounter
implements Counter,
ServoMeter {
    private final Id id;
    private final Clock clock;
    private final DoubleCounter impl;
    private final AtomicDouble count;
    private final AtomicLong lastUpdated;

    ServoCounter(Id id, Clock clock, DoubleCounter impl) {
        this.id = id;
        this.clock = clock;
        this.impl = impl;
        this.count = new AtomicDouble(0.0);
        this.lastUpdated = new AtomicLong(clock.wallTime());
    }

    @Override
    public void addMonitors(List<Monitor<?>> monitors) {
        monitors.add((Monitor<?>)this.impl);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        long now = this.clock.wallTime();
        return now - this.lastUpdated.get() > ServoRegistry.EXPIRATION_TIME_MILLIS;
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        double v = this.impl.getValue(0).doubleValue();
        return Collections.singleton(new Measurement(this.id(), now, v));
    }

    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.impl.increment(amount);
            this.count.addAndGet(amount);
            this.lastUpdated.set(this.clock.wallTime());
        }
    }

    public double actualCount() {
        return this.count.get();
    }
}

