/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy.processor;

import com.netflix.ribbon.RibbonResourceFactory;
import com.netflix.ribbon.http.HttpRequestTemplate;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.ProxyAnnotationException;
import com.netflix.ribbon.proxy.annotation.Http;
import com.netflix.ribbon.proxy.processor.AnnotationProcessor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpAnnotationProcessor
implements AnnotationProcessor<HttpResourceGroup.Builder, HttpRequestTemplate.Builder> {
    @Override
    public void process(String templateName, HttpRequestTemplate.Builder templateBuilder, Method method) {
        Http annotation = method.getAnnotation(Http.class);
        if (null == annotation) {
            throw new ProxyAnnotationException(String.format("Method %s misses @Http annotation", method.getName()));
        }
        Http.HttpMethod httpMethod = annotation.method();
        String uriTemplate = annotation.uri();
        HashMap headers = annotation.headers().length == 0 ? null : new HashMap();
        for (Http.Header h : annotation.headers()) {
            if (!headers.containsKey(h.name())) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(h.value());
                headers.put(h.name(), values);
                continue;
            }
            ((List)headers.get(h.name())).add(h.value());
        }
        templateBuilder.withMethod(httpMethod.name());
        if (uriTemplate != null) {
            templateBuilder.withUriTemplate(uriTemplate);
        }
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    templateBuilder.withHeader(key, value);
                }
            }
        }
    }

    @Override
    public void process(String groupName, HttpResourceGroup.Builder groupBuilder, RibbonResourceFactory resourceFactory, Class<?> interfaceClass) {
    }
}

