/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.tcp;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpClientConfig;

public class NetClientWrapper {
    private TcpClientConfig normalClientConfig;
    private NetClient normalNetClient;
    private TcpClientConfig sslClientConfig;
    private NetClient sslNetClient;

    public NetClientWrapper(Vertx vertx, TcpClientConfig normalClientConfig, TcpClientConfig sslClientConfig) {
        this.normalClientConfig = normalClientConfig;
        this.normalNetClient = vertx.createNetClient((NetClientOptions)normalClientConfig);
        this.sslClientConfig = sslClientConfig;
        this.sslNetClient = vertx.createNetClient((NetClientOptions)sslClientConfig);
    }

    public TcpClientConfig getClientConfig(boolean ssl) {
        if (ssl) {
            return this.sslClientConfig;
        }
        return this.normalClientConfig;
    }

    public void connect(boolean ssl, int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        if (ssl) {
            this.sslNetClient.connect(port, host, connectHandler);
            return;
        }
        this.normalNetClient.connect(port, host, connectHandler);
    }
}

