/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.metric.HystrixEvent;
import com.netflix.hystrix.metric.HystrixEventStream;
import com.netflix.hystrix.metric.consumer.BucketedCounterStream;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;

public abstract class BucketedRollingCounterStream<Event extends HystrixEvent, Bucket, Output>
extends BucketedCounterStream<Event, Bucket, Output> {
    private Observable<Output> sourceStream;
    private final AtomicBoolean isSourceCurrentlySubscribed = new AtomicBoolean(false);

    protected BucketedRollingCounterStream(HystrixEventStream<Event> stream, final int numBuckets, int bucketSizeInMs, Func2<Bucket, Event, Bucket> appendRawEventToBucket, final Func2<Output, Bucket, Output> reduceBucket) {
        super(stream, numBuckets, bucketSizeInMs, appendRawEventToBucket);
        Func1 reduceWindowToSummary = new Func1<Observable<Bucket>, Observable<Output>>(){

            public Observable<Output> call(Observable<Bucket> window) {
                return window.scan(BucketedRollingCounterStream.this.getEmptyOutputValue(), reduceBucket).skip(numBuckets);
            }
        };
        this.sourceStream = this.bucketedStream.window(numBuckets, 1).flatMap(reduceWindowToSummary).doOnSubscribe(new Action0(){

            public void call() {
                BucketedRollingCounterStream.this.isSourceCurrentlySubscribed.set(true);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                BucketedRollingCounterStream.this.isSourceCurrentlySubscribed.set(false);
            }
        }).share().onBackpressureDrop();
    }

    @Override
    public Observable<Output> observe() {
        return this.sourceStream;
    }

    boolean isSourceCurrentlySubscribed() {
        return this.isSourceCurrentlySubscribed.get();
    }
}

