/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracing;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.tracing.zipkin.ProviderInvocationAdapter;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class ZipkinProviderDelegate
implements ZipkinTracingDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ZipkinProviderDelegate.class);
    private final HttpServerHandler<Invocation, Response> handler;
    private final HttpTracing httpTracing;
    private final TraceContext.Extractor<Invocation> extractor;
    public static final String SPAN_ID_HEADER_NAME = "X-B3-SpanId";
    public static final String TRACE_ID_HEADER_NAME = "X-B3-TraceId";
    private static final Propagation.Getter<Invocation, String> INVOCATION_STRING_GETTER = (invocation, key) -> {
        String extracted = (String)invocation.getContext().get(key);
        if (StringUtils.isEmpty((Object)extracted) && SPAN_ID_HEADER_NAME.equals(key)) {
            extracted = (String)invocation.getContext().get(TRACE_ID_HEADER_NAME);
            LOG.debug("try to extract X-B3-SpanId, but the value is empty, replace with TraceId = [{}]", (Object)extracted);
        }
        return extracted;
    };

    ZipkinProviderDelegate(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.extractor = httpTracing.tracing().propagation().extractor(this.extractor());
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new ProviderInvocationAdapter());
    }

    @Override
    public Tracing tracer() {
        return this.httpTracing.tracing();
    }

    @Override
    public Span createSpan(Invocation invocation) {
        return this.handler.handleReceive(this.extractor, (Object)invocation);
    }

    @Override
    public void onResponse(Span span, Response response, Throwable error) {
        this.handler.handleSend((Object)response, error, span);
    }

    @Override
    public String name() {
        return "Zipkin provider";
    }

    private Propagation.Getter<Invocation, String> extractor() {
        return INVOCATION_STRING_GETTER;
    }
}

