/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.util.BitTools;
import java.util.Arrays;

public class PhDistanceF_L1
implements PhDistance {
    public static final PhDistanceF_L1 THIS = new PhDistanceF_L1();

    @Override
    public double dist(long[] v1, long[] v2) {
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double dl = BitTools.toDouble(v1[i]) - BitTools.toDouble(v2[i]);
            d += Math.abs(dl);
        }
        return d;
    }

    @Override
    public void toMBB(double distance, long[] center, long[] outMin, long[] outMax) {
        for (int i = 0; i < center.length; ++i) {
            double c = BitTools.toDouble(center[i]);
            outMin[i] = BitTools.toSortableLong(c - distance);
            outMax[i] = BitTools.toSortableLong(c + distance);
        }
    }

    @Override
    @Deprecated
    public void knnCalcDistances(long[] kNNCenter, long[] prefix, int bitsToIgnore, double[] outDistances) {
        int i;
        long maskSingleBit = 1L << bitsToIgnore - 1;
        if (maskSingleBit < 0L) {
            return;
        }
        long maskPrefix = -1L << bitsToIgnore;
        long maskPostFix = (maskPrefix ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
        for (i = 0; i < prefix.length; ++i) {
            long nodeCenter = prefix[i] & maskPrefix;
            boolean isLarger = kNNCenter[i] > (nodeCenter | maskPostFix);
            double dist = BitTools.toDouble(nodeCenter |= isLarger ? maskPostFix : maskSingleBit) - BitTools.toDouble(kNNCenter[i]);
            outDistances[i] = Math.abs(dist);
        }
        Arrays.sort(outDistances);
        for (i = 1; i < outDistances.length; ++i) {
            int n = i;
            outDistances[n] = outDistances[n] + outDistances[i - 1];
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

