/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2.primitives;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import org.apache.sedona.shaded.s2.primitives.Sorter;

public interface Pullable<T> {
    public PullIterator iterator(T var1);

    default public void forEach(T result, Runnable action) {
        PullIterator it = this.iterator(result);
        while (it.pull()) {
            action.run();
        }
    }

    public static interface PullList<T>
    extends PullCollection<T> {
        public void get(int var1, T var2);

        public void set(int var1, T var2);

        @Override
        default public PullIterator iterator(final T value) {
            return new PullIterator(){
                int index = 0;

                @Override
                public boolean pull() {
                    if (this.index >= this.size()) {
                        return false;
                    }
                    this.get(this.index, value);
                    ++this.index;
                    return true;
                }
            };
        }

        default public void copy(int fromIndex, int toIndex) {
            Object tmp = this.newElement();
            this.get(fromIndex, tmp);
            this.set(toIndex, tmp);
            this.destroyElement(tmp);
        }

        default public void swap(int indexA, int indexB) {
            Object tmp = this.newElement();
            this.get(indexA, tmp);
            this.copy(indexB, indexA);
            this.set(indexB, tmp);
            this.destroyElement(tmp);
        }

        default public void sort(final Comparator<T> comparator) {
            final Object left = this.newElement();
            final Object right = this.newElement();
            Sorter.sort(new Sorter.SortableCollection(){

                @Override
                public int size() {
                    return this.size();
                }

                @Override
                public void truncate(int end) {
                    this.truncate(end);
                }

                @Override
                public boolean less(int leftIndex, int rightIndex) {
                    this.get(leftIndex, left);
                    this.get(rightIndex, right);
                    return comparator.compare(left, right) < 0;
                }

                @Override
                public void swap(int indexA, int indexB) {
                    this.swap(indexA, indexB);
                }
            });
            this.destroyElement(left);
            this.destroyElement(right);
        }

        default public void resize(int newSize) {
            if (newSize < this.size()) {
                this.truncate(newSize);
            } else if (newSize > this.size()) {
                this.enlarge(newSize);
            }
        }

        public void truncate(int var1);

        public void enlarge(int var1);

        default public List<T> asList() {
            return new AbstractList<T>(){

                @Override
                public T get(int index) {
                    Object value = this.newElement();
                    this.get(index, value);
                    return value;
                }

                @Override
                public T set(int index, T newValue) {
                    Object previousValue = this.get(index);
                    this.set(index, newValue);
                    return previousValue;
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    public static interface PullCollection<T>
    extends Pullable<T> {
        public T newElement();

        default public void destroyElement(T value) {
        }

        @CanIgnoreReturnValue
        public boolean ensureCapacity(int var1);

        public int size();

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear();

        public void add(T var1);

        default public void addAll(Pullable<T> values) {
            T val = this.newElement();
            PullIterator it = values.iterator(val);
            while (it.pull()) {
                this.add(val);
            }
            this.destroyElement(val);
        }
    }

    public static interface PullIterator {
        public boolean pull();
    }
}

