/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.guava.collect;

import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.sedona.shaded.guava.annotations.GwtCompatible;
import org.apache.sedona.shaded.guava.annotations.GwtIncompatible;
import org.apache.sedona.shaded.guava.annotations.J2ktIncompatible;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.CollectSpliterators;
import org.apache.sedona.shaded.guava.collect.ImmutableAsList;
import org.apache.sedona.shaded.guava.collect.ImmutableCollection;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.guava.collect.ImmutableMap;
import org.apache.sedona.shaded.guava.collect.ImmutableSet;
import org.apache.sedona.shaded.guava.collect.Iterators;
import org.apache.sedona.shaded.guava.collect.UnmodifiableIterator;
import org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return new UnmodifiableIterator<V>(){
            final UnmodifiableIterator<Map.Entry<K, V>> entryItr;
            {
                this.entryItr = ((ImmutableSet)ImmutableMapValues.this.map.entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryItr.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.entryItr.next()).getValue();
            }
        };
    }

    @Override
    public Spliterator<V> spliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.map.entrySet())).spliterator(), Map.Entry::getValue);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    public ImmutableList<V> asList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(this){
            final /* synthetic */ ImmutableMapValues this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return this.this$0;
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            Object writeReplace() {
                return super.writeReplace();
            }
        };
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super V> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((? super K k, ? super V v) -> action.accept((Object)v));
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

