/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;

public class ObjRead {
    public int[][] faces;
    public int[][] normI;
    public double[][] pts;
    public double[][] norms;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjRead(File f) {
        BufferedReader br = null;
        try {
            int i;
            String line;
            System.out.println("reading " + String.valueOf(f));
            br = new BufferedReader(new FileReader(f), 0xA00000);
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            ArrayList<Point3d> normals = new ArrayList<Point3d>();
            ArrayList<int[]> listFaces = new ArrayList<int[]>();
            ArrayList<int[]> listNorms = new ArrayList<int[]>();
            while ((line = br.readLine()) != null) {
                try {
                    String[] params = line.split(" ");
                    if (params[0].equals("v")) {
                        points.add(new Point3d(Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])));
                        continue;
                    }
                    if (params[0].equals("vn")) {
                        normals.add(new Point3d(Double.parseDouble(params[1]), Double.parseDouble(params[2]), Double.parseDouble(params[3])));
                        continue;
                    }
                    if (!params[0].equals("f")) continue;
                    ArrayList<Integer> face = new ArrayList<Integer>();
                    ArrayList<Integer> ni = new ArrayList<Integer>();
                    for (int i2 = 1; i2 < params.length; ++i2) {
                        String[] inds = params[i2].split("/");
                        face.add(Integer.parseInt(inds[0]));
                        if (inds.length <= 2) continue;
                        ni.add(Integer.parseInt(inds[2]));
                    }
                    if (face.isEmpty()) continue;
                    listFaces.add(ObjRead.toArray(face));
                    listNorms.add(ObjRead.toArray(ni));
                }
                catch (Throwable th) {
                    System.err.println("at line " + line);
                    th.printStackTrace(System.err);
                }
            }
            this.pts = new double[points.size()][3];
            for (i = 0; i < points.size(); ++i) {
                Point3d pt = (Point3d)points.get(i);
                this.pts[i] = new double[]{pt.x, pt.y, pt.z};
            }
            if (!normals.isEmpty()) {
                this.norms = new double[normals.size()][3];
                for (i = 0; i < normals.size(); ++i) {
                    Point3d n = (Point3d)normals.get(i);
                    this.norms[i] = new double[]{n.x, n.y, n.z};
                }
            }
            Iterator iit = listFaces.iterator();
            Iterator nit = listNorms.iterator();
            block17: while (iit.hasNext()) {
                int[] inds = (int[])iit.next();
                int[] nnds = (int[])nit.next();
                for (int j = 0; j < inds.length; ++j) {
                    int n = j;
                    inds[n] = inds[n] - 1;
                    if (nnds.length > 0) {
                        int n2 = j;
                        nnds[n2] = nnds[n2] - 1;
                    }
                    if (inds[j] < this.pts.length && inds.length >= 3) continue;
                    System.out.println("discarding poly w/o points " + inds[j]);
                    iit.remove();
                    nit.remove();
                    continue block17;
                }
            }
            this.faces = ObjRead.arrayToArray(listFaces);
            this.normI = ObjRead.arrayToArray(listNorms);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                System.out.println("done reading " + String.valueOf(f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int[][] arrayToArray(List<int[]> is) {
        int[][] out = new int[is.size()][];
        for (int i = 0; i < is.size(); ++i) {
            out[i] = is.get(i);
        }
        return out;
    }

    private static int[] toArray(List<Integer> is) {
        int[] vals = new int[is.size()];
        for (int i = 0; i < is.size(); ++i) {
            vals[i] = is.get(i);
        }
        return vals;
    }

    public ObjRead(ObjRead obj) {
        int i;
        this.pts = new double[obj.pts.length][];
        for (i = 0; i < obj.pts.length; ++i) {
            this.pts[i] = Arrays.copyOf(obj.pts[i], obj.pts[i].length);
        }
        this.faces = new int[obj.faces.length][];
        for (i = 0; i < obj.faces.length; ++i) {
            this.faces[i] = Arrays.copyOf(obj.faces[i], obj.faces[i].length);
        }
    }

    public static void main(String[] args) {
        ObjRead or = new ObjRead(new File("/home/twak/Downloads/for_profile.obj"));
        System.out.println("found " + or.faces.length + " faces");
        System.out.println("found " + or.pts.length + " pts");
    }

    public List<Point3d> points() {
        return Arrays.stream(this.pts).map(x -> new Point3d((double[])x)).collect(Collectors.toList());
    }

    public double[] findExtent() {
        double[] out = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        for (double[] pt : this.pts) {
            for (int i = 0; i < 3; ++i) {
                out[i * 2 + 0] = Math.min(out[i * 2 + 0], pt[i]);
                out[i * 2 + 1] = Math.max(out[i * 2 + 1], pt[i]);
            }
        }
        return out;
    }
}

