/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.vecmath.Point3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Output;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.debug.DebugPointEditor;

public class JDebugDevice
extends JPanel {
    DebugDevice dd;
    private JList dataSetList;
    private JTextArea elementInfo;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jSrolelrThingy;
    private JPanel pointEditorPanel;

    public JDebugDevice() {
        this.initComponents();
    }

    public JDebugDevice(DebugDevice dd) {
        this.dd = dd;
        this.initComponents();
        this.initList();
    }

    private void initList() {
        this.dataSetList.clearSelection();
        DefaultListModel<DebugDevice.Status> model = new DefaultListModel<DebugDevice.Status>();
        for (DebugDevice.Status s2 : new ArrayList<DebugDevice.Status>(this.dd.toDisplay)) {
            model.addElement(s2);
        }
        this.dataSetList.setModel(model);
    }

    void pingChanged() {
        this.initList();
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSrolelrThingy = new JScrollPane();
        this.dataSetList = new JList();
        this.jScrollPane1 = new JScrollPane();
        this.elementInfo = new JTextArea();
        this.pointEditorPanel = new JPanel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.dataSetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JDebugDevice.this.dataSetListValueChanged(evt);
            }
        });
        this.jSrolelrThingy.setViewportView(this.dataSetList);
        this.elementInfo.setColumns(20);
        this.elementInfo.setRows(5);
        this.jScrollPane1.setViewportView(this.elementInfo);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE).addComponent(this.jSrolelrThingy, GroupLayout.Alignment.LEADING, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSrolelrThingy, -2, 168, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 253, Short.MAX_VALUE).addContainerGap()));
        this.pointEditorPanel.setLayout(new GridLayout(1, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.pointEditorPanel, -1, 376, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pointEditorPanel, GroupLayout.Alignment.LEADING, -1, 456, Short.MAX_VALUE)).addContainerGap()));
    }

    private void dataSetListValueChanged(ListSelectionEvent evt) {
        DebugDevice.Status t = (DebugDevice.Status)this.dataSetList.getSelectedValue();
        this.pointEditorPanel.removeAll();
        if (t == null) {
            return;
        }
        this.pointEditorPanel.add(new DebugPointEditor(t.corners, t.output){

            @Override
            public void hoverOver(Corner c) {
                JDebugDevice.this.elementInfo.setText(c.toString() + "\nnext " + c.nextC.toString() + "\nprev " + c.prevC.toString() + "\nnext " + c.nextL.toString() + "\nprev " + c.prevL.toString() + "\n");
                HashMap<Corner, Color> highlight = new HashMap<Corner, Color>();
                highlight.put(c.nextC, Color.cyan);
                highlight.put(c.prevC, Color.red);
                this.setHightLights(highlight);
            }

            @Override
            public void hoverOver(Edge e) {
                if (e == null) {
                    this.setHightLights(new HashMap<Corner, Color>());
                    return;
                }
                HashMap<Corner, Color> highlight = new HashMap<Corner, Color>();
                StringBuilder sb = new StringBuilder(e.toString() + "\na:" + e.getAngle() + "\ncc:\n");
                for (Corner c : e.currentCorners) {
                    highlight.put(c, Color.red);
                    sb.append("  " + String.valueOf(c) + "\n");
                }
                this.setHightLights(highlight);
                JDebugDevice.this.elementInfo.setText(sb.toString());
            }

            @Override
            public void hoverOver(Output.Face f, Output output) {
                JDebugDevice.this.elementInfo.setText(f.results.toString());
                HashMap<Corner, Color> highlight = new HashMap<Corner, Color>();
                this.highlight(f, Color.green.darker(), highlight);
                while ((f = f.parent) != null) {
                    this.highlight(f, new Color(255, 100, 255), highlight);
                }
                this.setHightLights(highlight);
            }

            public void highlight(Output.Face f, Color color, Map<Corner, Color> highlight) {
                for (Point3d p : f.results.map.keySet()) {
                    highlight.put(new Corner(p.x, p.y, p.z), color);
                    for (Point3d p2 : f.results.map.get(p)) {
                        this.highlightEdges.put(new Edge(p, p2, -5.59038737E8), color);
                    }
                }
            }
        });
        this.pointEditorPanel.revalidate();
        this.pointEditorPanel.repaint();
    }
}

