/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.utils.geom.LinearForm3D;

public class Ray3d {
    public Point3d origin;
    public Vector3d direction;

    public Ray3d(Tuple3d origin, Tuple3d direction) {
        this.origin = new Point3d(origin);
        this.direction = new Vector3d(direction);
    }

    public Point3d projectLine(Point3d ept) {
        return this.project(ept, false);
    }

    public Point3d projectSegment(Point3d ept) {
        return this.project(ept, true);
    }

    private Point3d project(Point3d ept, boolean segment) {
        double factor = this.projectParam(ept);
        if (segment && (factor < 0.0 || factor > 1.0)) {
            return null;
        }
        Point3d dest = new Point3d(this.direction);
        dest.scale(factor);
        dest.add(this.origin);
        return dest;
    }

    public double projectParam(Tuple3d ept) {
        Vector3d b = new Vector3d(ept);
        b.sub(this.origin);
        double factor = this.direction.dot(b) / this.direction.dot(this.direction);
        return factor;
    }

    public void transform(Matrix4d transform) {
        Point3d other = new Point3d(this.origin);
        other.add(this.direction);
        transform.transform(this.origin);
        transform.transform(other);
        other.sub(this.origin);
        this.direction = new Vector3d(other);
    }

    public double angleWith(LinearForm3D plane) {
        return plane.createNormalVector().angle(this.direction);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ray3d)) {
            return false;
        }
        Ray3d other = (Ray3d)obj;
        return this.origin.equals(other.origin) && this.direction.equals(other.direction);
    }

    public String toString() {
        return "[" + String.valueOf(this.origin) + "." + String.valueOf(this.direction) + "]";
    }

    public Point3d fromParam(double param) {
        Vector3d delta = new Vector3d(this.direction);
        delta.scale(param);
        delta.add(this.origin);
        return new Point3d(delta);
    }

    public static Ray3d fromStartEnd(Tuple3d start, Tuple3d end) {
        Vector3d delta = new Vector3d(end);
        delta.sub(start);
        return new Ray3d(start, delta);
    }

    public Point3d closestPointOn(Ray3d v) {
        Ray3d u = this;
        Vector3d w0 = new Vector3d(u.origin);
        w0.sub(v.origin);
        double a = u.direction.dot(u.direction);
        double b = u.direction.dot(v.direction);
        double c = v.direction.dot(v.direction);
        double d = u.direction.dot(w0);
        double e = v.direction.dot(w0);
        double tc = (a * e - b * d) / (a * c - b * b);
        Point3d out = new Point3d(v.direction);
        out.scale(tc);
        out.add(v.origin);
        return out;
    }
}

