/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.LittleEndianInput;
import org.apache.sedona.shaded.s2.LittleEndianOutput;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.PrimitiveArrays;
import org.apache.sedona.shaded.s2.R1Interval;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S1ChordAngle;
import org.apache.sedona.shaded.s2.S1Interval;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2Coder;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Projections;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2Shape;

@JsType
public final class S2Cap
implements S2Region,
Serializable {
    public static final S2Coder<S2Cap> CODER = new S2Coder<S2Cap>(){

        @Override
        @JsIgnore
        public void encode(S2Cap value, OutputStream output) throws IOException {
            value.encode(output);
        }

        @Override
        public S2Cap decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2Cap.decode(data.toInputStream(cursor));
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    };
    private final S2Point axis;
    private final S1ChordAngle radius;

    private S2Cap(S2Point axis, S1ChordAngle radius) {
        this.axis = axis;
        this.radius = radius;
        assert (this.isValid());
    }

    public static S2Cap fromAxisChord(S2Point center, S1ChordAngle radius) {
        return new S2Cap(center, radius);
    }

    public static S2Cap fromAxisHeight(S2Point axis, double height) {
        assert (S2.isUnitLength(axis));
        return new S2Cap(axis, S1ChordAngle.fromLength2(2.0 * height));
    }

    public static S2Cap fromAxisAngle(S2Point axis, S1Angle angle) {
        Preconditions.checkArgument(S2.isUnitLength(axis));
        return S2Cap.fromAxisChord(axis, S1ChordAngle.fromS1Angle(S1Angle.radians(Math.min(angle.radians(), Math.PI))));
    }

    public static S2Cap fromAxisArea(S2Point axis, double area) {
        Preconditions.checkArgument(S2.isUnitLength(axis));
        return new S2Cap(axis, S1ChordAngle.fromLength2(area / Math.PI));
    }

    public static S2Cap empty() {
        return new S2Cap(S2Point.X_POS, S1ChordAngle.NEGATIVE);
    }

    public static S2Cap full() {
        return new S2Cap(S2Point.X_POS, S1ChordAngle.STRAIGHT);
    }

    public S2Point axis() {
        return this.axis;
    }

    public S1ChordAngle radius() {
        return this.radius;
    }

    public double height() {
        return 0.5 * this.radius.getLength2();
    }

    public double area() {
        return Math.PI * 2 * Math.max(0.0, this.height());
    }

    public S2Point getCentroid() {
        if (this.isEmpty()) {
            return new S2Point();
        }
        double r = 1.0 - 0.5 * this.height();
        return this.axis.mul(r * this.area());
    }

    public S1Angle angle() {
        return this.radius.toAngle();
    }

    public boolean isValid() {
        return S2.isUnitLength(this.axis) && this.radius.getLength2() <= 4.0;
    }

    public boolean isEmpty() {
        return this.radius.isNegative();
    }

    public boolean isFull() {
        return S1ChordAngle.STRAIGHT.equals(this.radius);
    }

    @CheckReturnValue
    public S2Cap complement() {
        if (this.isFull()) {
            return S2Cap.empty();
        }
        if (this.isEmpty()) {
            return S2Cap.full();
        }
        return S2Cap.fromAxisChord(this.axis.neg(), S1ChordAngle.fromLength2(4.0 - this.radius.getLength2()));
    }

    @JsMethod(name="containsCap")
    public boolean contains(S2Cap other) {
        if (this.isFull() || other.isEmpty()) {
            return true;
        }
        S1ChordAngle axialDistance = new S1ChordAngle(this.axis, other.axis);
        return this.radius.compareTo(S1ChordAngle.add(axialDistance, other.radius)) >= 0;
    }

    @JsMethod(name="intersectsCap")
    public boolean intersects(S2Cap other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        S1ChordAngle axialDistance = new S1ChordAngle(this.axis, other.axis);
        return S1ChordAngle.add(this.radius, other.radius).greaterOrEquals(axialDistance);
    }

    public boolean interiorIntersects(S2Cap other) {
        return !this.complement().contains(other);
    }

    public boolean interiorContains(S2Point p) {
        Preconditions.checkArgument(S2.isUnitLength(p));
        return this.isFull() || new S1ChordAngle(this.axis, p).compareTo(this.radius) < 0;
    }

    @CheckReturnValue
    public S2Cap addPoint(S2Point p) {
        Preconditions.checkArgument(S2.isUnitLength(p));
        if (this.isEmpty()) {
            return new S2Cap(p, S1ChordAngle.ZERO);
        }
        return new S2Cap(this.axis, S1ChordAngle.fromLength2(Math.max(this.radius.getLength2(), this.axis.getDistance2(p))));
    }

    @CheckReturnValue
    public S2Cap addCap(S2Cap other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        S1ChordAngle dist = S1ChordAngle.add(new S1ChordAngle(this.axis, other.axis), other.radius);
        dist = dist.plusError(8.926193117986258E-16 * dist.getLength2());
        return new S2Cap(this.axis, S1ChordAngle.max(this.radius, dist));
    }

    public S2Cap expanded(S1Angle distance) {
        Preconditions.checkState(distance.radians() >= 0.0);
        if (this.isEmpty()) {
            return S2Cap.empty();
        }
        return new S2Cap(this.axis, S1ChordAngle.add(this.radius, S1ChordAngle.fromS1Angle(distance)));
    }

    public S2Cap union(S2Cap other) {
        S1Angle otherRadius;
        S1Angle distance;
        if (this.radius.lessThan(other.radius)) {
            return other.union(this);
        }
        if (this.isFull() || other.isEmpty()) {
            return this;
        }
        S1Angle thisRadius = this.angle();
        if (thisRadius.greaterOrEquals((distance = new S1Angle(this.axis, other.axis)).add(otherRadius = other.angle()))) {
            return this;
        }
        S1Angle resultRadius = distance.add(thisRadius).add(otherRadius).mul(0.5);
        S2Point resultAxis = S2EdgeUtil.getPointOnLine(this.axis, other.axis, distance.sub(thisRadius).add(otherRadius).mul(0.5));
        return S2Cap.fromAxisAngle(resultAxis, resultRadius);
    }

    @Override
    public S2Cap getCapBound() {
        return this;
    }

    @Override
    public S2LatLngRect getRectBound() {
        double sinC;
        double sinA;
        if (this.isEmpty()) {
            return S2LatLngRect.empty();
        }
        if (this.isFull()) {
            return S2LatLngRect.full();
        }
        S2LatLng axisLatLng = new S2LatLng(this.axis);
        double capAngle = this.angle().radians();
        boolean allLongitudes = false;
        double[] lat = new double[2];
        double[] lng = new double[]{-Math.PI, Math.PI};
        lat[0] = axisLatLng.lat().radians() - capAngle;
        if (lat[0] <= -1.5707963267948966) {
            lat[0] = -1.5707963267948966;
            allLongitudes = true;
        }
        lat[1] = axisLatLng.lat().radians() + capAngle;
        if (lat[1] >= 1.5707963267948966) {
            lat[1] = 1.5707963267948966;
            allLongitudes = true;
        }
        if (!allLongitudes && (sinA = S1ChordAngle.sin(this.radius)) <= (sinC = Math.cos(axisLatLng.lat().radians()))) {
            double angleA = Math.asin(sinA / sinC);
            lng[0] = Platform.IEEEremainder(axisLatLng.lng().radians() - angleA, Math.PI * 2);
            lng[1] = Platform.IEEEremainder(axisLatLng.lng().radians() + angleA, Math.PI * 2);
        }
        return new S2LatLngRect(new R1Interval(lat[0], lat[1]), new S1Interval(lng[0], lng[1]));
    }

    @Override
    public void getCellUnionBound(Collection<S2CellId> results) {
        results.clear();
        int level = S2Projections.MIN_WIDTH.getMaxLevel(this.angle().radians()) - 1;
        if (level < 0) {
            Collections.addAll(results, S2CellId.FACE_CELLS);
        } else {
            S2CellId.fromPoint(this.axis).getVertexNeighbors(level, results);
        }
    }

    @Override
    @JsMethod(name="containsCell")
    public boolean contains(S2Cell cell) {
        S2Point[] vertices = new S2Point[4];
        for (int k = 0; k < 4; ++k) {
            vertices[k] = cell.getVertex(k);
            if (this.contains(vertices[k])) continue;
            return false;
        }
        return !this.complement().intersects(cell, vertices);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        S2Point[] vertices = new S2Point[4];
        for (int k = 0; k < 4; ++k) {
            vertices[k] = cell.getVertex(k);
            if (!this.contains(vertices[k])) continue;
            return true;
        }
        return this.intersects(cell, vertices);
    }

    public boolean intersects(S2Cell cell, S2Point[] vertices) {
        if (this.radius.compareTo(S1ChordAngle.RIGHT) >= 0) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (cell.contains(this.axis)) {
            return true;
        }
        double sin2Angle = S1ChordAngle.sin2(this.radius);
        for (int k = 0; k < 4; ++k) {
            S2Point edge = cell.getEdgeRaw(k);
            double dot = this.axis.dotProd(edge);
            if (dot > 0.0) continue;
            if (dot * dot > sin2Angle * edge.norm2()) {
                return false;
            }
            S2Point dir = edge.crossProd(this.axis);
            if (!(dir.dotProd(vertices[k]) < 0.0) || !(dir.dotProd(vertices[k + 1 & 3]) > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JsMethod(name="containsPoint")
    public boolean contains(S2Point p) {
        return new S1ChordAngle(this.axis, p).compareTo(this.radius) <= 0;
    }

    public boolean equals(Object that) {
        if (that instanceof S2Cap) {
            S2Cap other = (S2Cap)that;
            return this.axis.equalsPoint(other.axis) && this.radius.equals(other.radius) || this.isEmpty() && other.isEmpty() || this.isFull() && other.isFull();
        }
        return false;
    }

    public int hashCode() {
        if (this.isFull()) {
            return 17;
        }
        if (this.isEmpty()) {
            return 37;
        }
        return 37 * (629 + this.axis.hashCode()) + this.radius.hashCode();
    }

    boolean approxEquals(S2Cap other, double maxError) {
        double r2 = this.radius.getLength2();
        double otherR2 = other.radius.getLength2();
        return S2.approxEquals(this.axis, other.axis, maxError) && Math.abs(r2 - otherR2) <= maxError || this.isEmpty() && otherR2 <= maxError || other.isEmpty() && r2 <= maxError || this.isFull() && otherR2 >= 2.0 - maxError || other.isFull() && r2 >= 2.0 - maxError;
    }

    boolean approxEquals(S2Cap other) {
        return this.approxEquals(other, 1.0E-14);
    }

    public String toString() {
        return "[Point = " + this.axis + " Radius = " + this.radius + "]";
    }

    @JsIgnore
    public void encode(OutputStream os) throws IOException {
        this.encode(new LittleEndianOutput(os));
    }

    void encode(LittleEndianOutput os) throws IOException {
        this.axis.encode(os);
        os.writeDouble(this.radius.getLength2());
    }

    @JsIgnore
    public static S2Cap decode(InputStream is) throws IOException {
        return S2Cap.decode(new LittleEndianInput(is));
    }

    static S2Cap decode(LittleEndianInput is) throws IOException {
        S2Point axis = S2Point.decode(is);
        if (!S2.isUnitLength(axis)) {
            throw new IOException("Decoded axis is not unit length: " + axis);
        }
        double length2 = is.readDouble();
        if (Double.isNaN(length2)) {
            throw new IOException("Invalid decoded length2: " + length2);
        }
        S1ChordAngle chord = S1ChordAngle.fromLength2(length2);
        return S2Cap.fromAxisChord(axis, chord);
    }

    public static class Builder {
        private S2Point axis = null;
        private S1Angle radius = null;

        public S2Cap build() {
            if (this.radius == null) {
                return S2Cap.empty();
            }
            if (this.radius.radians() > Math.PI) {
                return S2Cap.full();
            }
            return S2Cap.fromAxisAngle(this.axis, this.radius);
        }

        public boolean isEmpty() {
            return this.radius == null;
        }

        public boolean isFull() {
            return this.radius != null && this.radius.radians() >= Math.PI;
        }

        public void add(S2Shape.MutableEdge edge) {
            if (this.isFull()) {
                return;
            }
            if (this.isEmpty()) {
                this.axis = edge.getStart().add(edge.getEnd()).normalize();
                this.radius = new S1Angle(edge.getStart(), edge.getEnd());
                return;
            }
            this.add(edge.getStart());
            this.add(edge.getEnd());
        }

        public void add(S2Point p) {
            if (this.isFull()) {
                return;
            }
            if (this.isEmpty()) {
                this.axis = p;
                this.radius = S1Angle.ZERO;
                return;
            }
            S1Angle distance = new S1Angle(this.axis, p);
            if (this.radius.greaterOrEquals(distance)) {
                return;
            }
            this.axis = S2EdgeUtil.getPointOnLine(this.axis, p, distance.sub(this.radius).mul(0.5));
            this.radius = distance.add(this.radius).mul(0.5);
        }
    }
}

