/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.storage.StorageLevel;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Random;

public final class MaximalIndependentSet$
implements scala.Serializable,
Logging {
    public static MaximalIndependentSet$ MODULE$;
    private final String probCol;
    private final String degCol;
    private final String isNominated;
    private final String notJoinedMISCol;
    private final String isMIS;
    private transient Logger org$graphframes$Logging$$logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MaximalIndependentSet$();
    }

    @Override
    public void logDebug(Function0<String> s2) {
        Logging.logDebug$(this, s2);
    }

    @Override
    public void logWarn(Function0<String> s2) {
        Logging.logWarn$(this, s2);
    }

    @Override
    public void logInfo(Function0<String> s2) {
        Logging.logInfo$(this, s2);
    }

    @Override
    public void logTrace(Function0<String> s2) {
        Logging.logTrace$(this, s2);
    }

    @Override
    public void resultIsPersistent() {
        Logging.resultIsPersistent$(this);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        MaximalIndependentSet$ maximalIndependentSet$ = this;
        synchronized (maximalIndependentSet$) {
            if (!this.bitmap$trans$0) {
                this.org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        if (!this.bitmap$trans$0) {
            return this.org$graphframes$Logging$$logger$lzycompute();
        }
        return this.org$graphframes$Logging$$logger;
    }

    private String probCol() {
        return this.probCol;
    }

    private String degCol() {
        return this.degCol;
    }

    private String isNominated() {
        return this.isNominated;
    }

    private String notJoinedMISCol() {
        return this.notJoinedMISCol;
    }

    private String isMIS() {
        return this.isMIS;
    }

    public Dataset<Row> org$graphframes$lib$MaximalIndependentSet$$run(GraphFrame graph, int checkpointInterval, boolean useLocalCheckpoints, StorageLevel storageLevel, long seed) {
        Dataset dataset;
        boolean shouldCheckpoint;
        ObjectRef vertices = ObjectRef.create((Object)graph.vertices().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.5)).cast((DataType)DoubleType$.MODULE$).alias(this.probCol())})).persist(storageLevel));
        Dataset edges = graph.edges().select(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{GraphFrame$.MODULE$.DST()})).union(graph.edges().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).alias(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).alias(GraphFrame$.MODULE$.DST())}))).filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).distinct().persist(storageLevel);
        Dataset misDF = graph.vertices().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)).alias(this.isMIS())}));
        IntRef i = IntRef.create((int)0);
        boolean converged = false;
        SparkSession spark = graph.vertices().sparkSession();
        boolean bl = shouldCheckpoint = checkpointInterval > 0;
        if (!useLocalCheckpoints && spark.sparkContext().getCheckpointDir().isEmpty()) {
            Option option = spark.conf().getOption("spark.checkpoint.dir");
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IOException("Checkpoint directory is not set. Please set it first using sc.setCheckpointDir()or by specifying the conf 'spark.checkpoint.dir'.");
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            String d = (String)some.value();
            spark.sparkContext().setCheckpointDir(d);
        }
        Random rng = new Random(seed);
        String originalAQE = spark.conf().get("spark.sql.adaptive.enabled");
        try {
            spark.conf().set("spark.sql.adaptive.enabled", "false");
            while (!converged) {
                long iterSeed = rng.nextLong();
                Dataset effectiveDegrees = edges.join((Dataset)vertices.elem, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.sum(functions$.MODULE$.col(this.probCol())).alias(this.degCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
                Dataset probs = ((Dataset)vertices.elem).join(effectiveDegrees, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()))).drop(GraphFrame$.MODULE$.SRC()).withColumn(this.probCol(), functions$.MODULE$.when(functions$.MODULE$.col(this.degCol()).$greater$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2))), (Object)functions$.MODULE$.col(this.probCol()).$div((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)2.0)))).otherwise((Object)functions$.MODULE$.when(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)).$times((Object)functions$.MODULE$.col(this.probCol())).$less$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.5))), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)).$times((Object)functions$.MODULE$.col(this.probCol()))).otherwise((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.5))))).withColumn(this.isNominated(), functions$.MODULE$.col(this.probCol()).$greater$eq((Object)functions$.MODULE$.rand(iterSeed))).select(GraphFrame$.MODULE$.ID(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.isNominated(), this.probCol()})).persist(storageLevel);
                Dataset isolatedVertices = ((Dataset)vertices.elem).join(probs.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID())})), (Seq)new .colon.colon((Object)GraphFrame$.MODULE$.ID(), (List)Nil$.MODULE$), "left_anti").select(GraphFrame$.MODULE$.ID(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                Dataset isJoinedMIS = probs.join(edges.join(probs, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.bool_or(functions$.MODULE$.col(this.isNominated())).alias(this.notJoinedMISCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.ID()))).select(GraphFrame$.MODULE$.ID(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.probCol(), this.isNominated(), this.notJoinedMISCol()}));
                Dataset joinedMIS = isJoinedMIS.filter(functions$.MODULE$.col(this.notJoinedMISCol()).unary_$bang().$amp$amp((Object)functions$.MODULE$.col(this.isNominated()))).select(GraphFrame$.MODULE$.ID(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                Dataset updatedMIS = misDF.join(isolatedVertices.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).alias("f")})), (Seq)new .colon.colon((Object)GraphFrame$.MODULE$.ID(), (List)Nil$.MODULE$), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col(this.isMIS()).$bar$bar((Object)functions$.MODULE$.col("f")).alias(this.isMIS())})).join(joinedMIS.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).alias("f")})), (Seq)new .colon.colon((Object)GraphFrame$.MODULE$.ID(), (List)Nil$.MODULE$), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col(this.isMIS()).$bar$bar((Object)functions$.MODULE$.col("f")).alias(this.isMIS())})).persist(storageLevel);
                if (useLocalCheckpoints) {
                    Dataset newMis = updatedMIS.localCheckpoint(true);
                    newMis.count();
                    misDF.unpersist();
                    misDF = newMis;
                } else {
                    Dataset newMis = updatedMIS.checkpoint(true);
                    newMis.count();
                    misDF.unpersist();
                    misDF = newMis;
                }
                Dataset neighborsOfMIS = edges.join(joinedMIS, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())}));
                Dataset updatedVertices = probs.join(joinedMIS, (Seq)new .colon.colon((Object)GraphFrame$.MODULE$.ID(), (List)Nil$.MODULE$), "left_anti").join(neighborsOfMIS, functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())), "left_anti").select(GraphFrame$.MODULE$.ID(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.probCol()}));
                vertices.elem = shouldCheckpoint && i.elem % checkpointInterval == 0 ? (useLocalCheckpoints ? updatedVertices.localCheckpoint(true) : updatedVertices.checkpoint(true)) : updatedVertices;
                converged = ((Dataset)vertices.elem).isEmpty();
                updatedVertices.unpersist();
                probs.unpersist();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("iteration ").append(i$1.elem).append(" finished, vertices left: ").append(((Dataset)vertices$1.elem).count()).toString());
                ++i.elem;
            }
            ((Dataset)vertices.elem).unpersist(true);
            edges.unpersist(true);
            Dataset mis = misDF.filter(functions$.MODULE$.col(this.isMIS())).select(GraphFrame$.MODULE$.ID(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).persist(storageLevel);
            mis.count();
            this.resultIsPersistent();
            misDF.unpersist(true);
            dataset = mis;
        }
        finally {
            spark.conf().set("spark.sql.adaptive.enabled", originalAQE);
        }
        return dataset;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MaximalIndependentSet$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.probCol = "prob";
        this.degCol = "effectiveDegree";
        this.isNominated = "isNominated";
        this.notJoinedMISCol = "notJoinMIS";
        this.isMIS = "isMIS";
    }
}

