Sedona has received numerous help from the community. This page lists the contributors and committers of Apache Sedona. People on this page are ordered by their last name.

## Committers

A contributor who contributes enough code to Sedona will be promoted to a committer. A committer has the write access to Sedona main repository

## Project Management Committee (PMC)

A committer will be promoted to a PMC member when the community thinks he/she is able to be in charge at least a major component of this project.

Current Sedona PMC members are as follows:


|        Name       |  GitHub ID  |        Apache ID       |
|:-----------------:|:-----------:|:----------------------:|
|    Adam Binford   | Kimahriman  |  kimahriman@apache.org |
| Kanchan Chowdhury | kanchanchy  | kanchanchy@apache.org  |
| Paweł Kociński    |  Imbruced   |   imbruced@apache.org  |
|      Yitao Li     |  yitao-li   |   yitaoli@apache.org   |
|   Netanel Malka   | netanel246  |    malka@apache.org    |
|   Mohamed Sarwat  |   Sarwat    |   mosarwat@apache.org  |
| Kengo Seki        |   sekikn    | sekikn@apache.org      |
|    Sachio Wakai   |  SW186000   |    swakai@apache.org   |
|     Jinxuan Wu    | jinxuan     |   jinxuanw@apache.org  |
|       Jia Yu      |  jiayuasu   |    jiayu@apache.org    |
|    Zongsi Zhang   | zongsizhang | zongsizhang@apache.org |


## Mentors

Mentors from Apache Incubator help the project to turn into a good shape following the "Apache" way. Thank you, mentors!


|         Name         | Apache id |
|:--------------------:|:------------------------:|
|     Felix Cheung     |	felixcheung@apache.org |
|     Von Gosling      | vongosling@apache.org |
| Jean-Baptiste Onofré | jbonofre@apache.org |
|   George Percivall   | percivall@apache.org |
|     Sunil Govindan   |sunilg@apache.org|

## Become a committer

To get started contributing to Sedona, learn [how to contribute](../rule) – anyone can submit patches, documentation and examples to the project.

The PMC regularly adds new committers from the active contributors, based on their contributions to Sedona. The qualifications for new committers include:

* Sustained contributions to Spark: Committers should have a history of major contributions to Sedona.
* Quality of contributions: Committers more than any other community member should submit simple, well-tested, and well-designed patches. In addition, they should show sufficient expertise to be able to review patches.
* Community involvement: Committers should have a constructive and friendly attitude in all community interactions. They should also be active on the dev mailing list & Gitter, and help mentor newer contributors and users.

The PMC also adds new PMC members. PMC members are expected to carry out PMC responsibilities as described in Apache Guidance, including helping vote on releases, enforce Apache project trademarks, take responsibility for legal and license issues, and ensure the project follows Apache project mechanics. The PMC periodically adds committers to the PMC who have shown they understand and can help with these activities.

Currently, Sedona makes committers PMC members automatically.

## Nominate a committer or PMC member

Steps are as follows:
1. Call a vote (templates/committerVote.txt)
2. Close the vote. If the result is positive, invite the new committer.

### Call for a vote
We do the vote and discussion on the private@sedona.apache.org to enable a frank discussion. Please read [ASF Incubator New committer Discussion](hhttps://incubator.apache.org/guides/ppmc.html) for notable items.

Let the Vote thread run for one week. A positive result is achieved by Consensus Approval: at least 3 +1 votes and no vetoes.

#### PMC vote template

This is the email to commence a vote for a new PMC candidate. New PMC members need to be voted for by the existing PMC members and subsequently approved by the Board (or Incubator PMC for incubating projects).

```
To: private@sedona.apache.org
Subject: [VOTE] New PMC candidate: [New PMC NAME]

[ add the reasons behind your nomination here ]

Voting ends one week from today, or until at least 3 +1 votes are cast.

See voting guidelines at
https://incubator.apache.org/guides/ppmc.html
```

### Close a vote

This email ends the vote and reports the result to the project.

```
To: private@sedona.apache.org
Subject: [VOTE][RESULT] New PMC candidate: [New PMC NAME]

The vote has now closed: [paste the vote thread on https://lists.apache.org/list.html?private@sedona.apache.org]. The results are:

Binding Votes:

+1 [TOTAL BINDING +1 VOTES]
 0 [TOTAL BINDING +0/-0 VOTES]
-1 [TOTAL BINDING -1 VOTES]

The vote is ***successful/not successful***
```

### Send a notice to IPMC

The nominating PPMC member should send a message to the IPMC (private@incubator.apache.org) with a reference to the vote result in the following form:

```
To: private at incubator.apache.org
CC: private at sedona.apache.org
Subject: [NOTICE] New PMC NAME for Apache Sedona PPMC
Body:

New PMC NAME has been voted as a new member of the Apache Sedona PPMC. the vote thread is at: *link to the vote result thread*
```

**Note that there is a grace period of 72 hours from when the PPMC sends the NOTICE to the IPMC to when the PPMC should formally invite the proposed member. This is an important part of the overall process. Failure to do this can result in an embarassing situation for people involved.**

### Send the invitation

```
To: New PMC Email address
CC: private@sedona.apache.org

Dear NEW PMC NAME,

In recognition of your demonstrated commitment to, and alignment with, the
goals of the Apache Sedona project, the Sedona PPMC has voted to offer you
membership in the Sedona PPMC ("Podling Project Management Committee").

Please let us know if you accept by replying to this email 
(including private@sedona.apache.org).

The PPMC is the Incubator podling version of a project PMC ("Project
Management Committee") that for every top-level project is tasked by the
Apache Board of Directors with official oversight and binding votes in
that project.  When Sedona graduates from the Incubator to a top-level
project, the project PMC is usually formed from the membership of the PPMC.
Note that while participation in the PMC after graduation is not
guaranteed, simply continuing your constructive and active participation
is usually sufficient.

As a PPMC member, and later as a PMC member, you are responsible for
continuing the general project, code, and community oversight that you
have exhibited so far.  The votes of the PPMC are not legally binding;
votes of the Incubator PMC are.  However, many of the PPMC members
are also Incubator PMC members, so they implicitly cast binding votes
when we vote on PPMC issues.  While this is an important legal
distinction, it shouldn't enter your thinking when working on the PPMC -
members should treat every decision as if it were legally binding for the
 ASF. Also, in day-to-day activities, the Incubator PMC member vs PPMC 
 member distinction should be invisible -- we are peers.

Finally, the PPMC (and assuming graduation, the PMC) is not meant to create 
a hierarchy within the committership or the community.  In fact, a goal is 
to add all committers over time to the PPMC/PMC, as our belief is that those 
who do the work should get a binding vote.  Therefore, in our day-to-day
interactions with the rest of the community, we continue to interact as
peers, where every reasonable opinion is considered, and all community
members are invited to participate in our public voting.  If there ever
is a situation where the PMC/PPMC's view differs significantly from that 
of the rest of the community, this is a symptom of a problem that needs to
be addressed.

With the expectation of your acceptance, welcome!

The Apache Sedona PPMC
```

### PMC Accept and ICLA instruction

```
To: New PMC Email address
Cc: private@sedona.apache.org
Subject: Re: invitation to become Apache Sedona PMC

Welcome. Here are the next steps in becoming a project committer. After that we will make
an announcement to the dev@sedona.apache.org

1. You need to send a Contributor License Agreement to the ASF.
Normally you would send an Individual CLA. If you also make
contributions done in work time or using work resources,
see the Corporate CLA. Ask us if you have any issues.
https://www.apache.org/licenses/#clas.

You need to choose a preferred ASF user name and alternatives.
In order to ensure it is available you can view a list of taken IDs at
https://people.apache.org/committer-index.html

Please notify us when you have submitted the CLA and by what means 
you did so. This will enable us to monitor its progress.

We will arrange for your Apache user account when the CLA has 
been recorded.

2. After that is done, please use your ASF email to subscribe to the dev@sedona.apache.org
and private@sedona.apache.org by sending an email to dev-subscribe@sedona.apache.org and 
private-subscribe@sedona.apache.org. We generally discuss everything on the dev list and 
keep the private@sedona.apache.org list for occasional matters which must be private.

The developer section of the website describes roles within the ASF and provides other
resources:
  https://www.apache.org/foundation/how-it-works.html
  https://www.apache.org/dev/

The incubator also has some useful information for new committers
in incubating projects:
  https://incubator.apache.org/guides/committer.html
  https://incubator.apache.org/guides/ppmc.html

Just as before you became a committer, participation in any ASF community
requires adherence to the ASF Code of Conduct:
  https://www.apache.org/foundation/policies/conduct.html

Yours,
The Apache Sedona PMC
```

### Create ASF account

Once the ICLA has been filed, use the [ASF New Account Request form](https://whimsy.apache.org/officers/acreq) to generate the request. Sedona mentors will request the account.

Once Sedona graduates, the PMC chair will make the request.

### Add to the system

Once the new PPMC subscribes to the Sedona mailing lists using his/her ASF account, one of the PPMC needs to add the new PPMC to the Whimsy system (https://whimsy.apache.org/roster/ppmc/sedona).

### PMC annoucement

This is the email to announce the new committer to sedona-dev once the account has been created.


```
To: dev@sedona.apache.org
Subject: new committer: ###New PMC NAME

The Podling Project Management Committee (PPMC) for Apache Sedona
has invited New PMC NAME to become a committer and we are pleased 
to announce that they have accepted.

### add specific details here ###

Being a committer enables easier contribution to the
project since there is no need to go via the patch
submission process. This should enable better productivity.
A PMC member helps manage and guide the direction of the project.
```

### Committer Done Template

After the committer account is established.

```
To: New PMC Email
CC: private@sedona.apache.org
Subject: account request: New PMC NAME

New PMC NAME, as you know, the ASF Infrastructure has set up your
committer account with the username '####'.

You have commit access to specific sections of the
ASF repository, as follows:
https://github.com/apache/incubator-sedona

You need to link your ASF Account with your GitHub account.

Here are the steps

1. Verify you have a Github ID enabled with 2FA
	* https://help.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/
2. Enter your Github ID into your Apache ID profile https://id.apache.org/
3. Merge your Apache and GitHub accounts using
	* GitBox (Apache Account Linking utility) https://gitbox.apache.org/setup/
	* You should see 3 green checks in GitBox.
	* Wait at least 30  minutes for an email inviting you to Apache GitHub Organization and accept invitation
4. After accepting the Github Invitation verify that you are a 
member of the team https://github.com/orgs/apache/teams/sedona-committers

Optionally, if you want, please follow the instructions to set up your GitHub, SSH, svn password, svn configuration, email forwarding, etc.
https://www.apache.org/dev/#committers

Additionally, if you have been elected to the Sedona Podling
 Project Mgmt. Committee (PPMC): Verify you are part of the LDAP sedona
  ppmc https://whimsy.apache.org/roster/ppmc/sedona
```