/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.enums.JoinBuildSide;
import org.apache.sedona.core.enums.JoinSparitionDominantSide;
import org.apache.spark.SparkConf;
import org.locationtech.jts.geom.Envelope;

public class SedonaConf
implements Serializable {
    private Boolean useIndex = false;
    private IndexType indexType = IndexType.QUADTREE;
    private JoinSparitionDominantSide joinSparitionDominantSide = JoinSparitionDominantSide.LEFT;
    private JoinBuildSide joinBuildSide = JoinBuildSide.LEFT;
    private Long joinApproximateTotalCount = -1L;
    private Envelope datasetBoundary = new Envelope(0.0, 0.0, 0.0, 0.0);
    private Integer fallbackPartitionNum = -1;
    private GridType joinGridType = GridType.KDBTREE;

    public SedonaConf(SparkConf sparkConf) {
        this.useIndex = sparkConf.getBoolean("sedona.global.index", true);
        this.indexType = IndexType.getIndexType(sparkConf.get("sedona.global.indextype", "quadtree"));
        this.joinApproximateTotalCount = sparkConf.getLong("sedona.join.approxcount", -1L);
        String[] boundaryString = sparkConf.get("sedona.join.boundary", "0,0,0,0").split(",");
        this.datasetBoundary = new Envelope(Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[0]));
        this.joinGridType = GridType.getGridType(sparkConf.get("sedona.join.gridtype", "kdbtree"));
        this.joinBuildSide = JoinBuildSide.getBuildSide(sparkConf.get("sedona.join.indexbuildside", "left"));
        this.joinSparitionDominantSide = JoinSparitionDominantSide.getJoinSparitionDominantSide(sparkConf.get("sedona.join.spatitionside", "left"));
        this.fallbackPartitionNum = sparkConf.getInt("sedona.join.numpartition", -1);
    }

    public Boolean getUseIndex() {
        return this.useIndex;
    }

    public void setUseIndex(Boolean useIndex) {
        this.useIndex = useIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public Long getJoinApproximateTotalCount() {
        return this.joinApproximateTotalCount;
    }

    public void setJoinApproximateTotalCount(Long joinApproximateTotalCount) {
        this.joinApproximateTotalCount = joinApproximateTotalCount;
    }

    public Envelope getDatasetBoundary() {
        return this.datasetBoundary;
    }

    public void setDatasetBoundary(Envelope datasetBoundary) {
        this.datasetBoundary = datasetBoundary;
    }

    public JoinBuildSide getJoinBuildSide() {
        return this.joinBuildSide;
    }

    public void setJoinBuildSide(JoinBuildSide joinBuildSide) {
        this.joinBuildSide = joinBuildSide;
    }

    public GridType getJoinGridType() {
        return this.joinGridType;
    }

    public void setJoinGridType(GridType joinGridType) {
        this.joinGridType = joinGridType;
    }

    public JoinSparitionDominantSide getJoinSparitionDominantSide() {
        return this.joinSparitionDominantSide;
    }

    public void setJoinSparitionDominantSide(JoinSparitionDominantSide joinSparitionDominantSide) {
        this.joinSparitionDominantSide = joinSparitionDominantSide;
    }

    public Integer getFallbackPartitionNum() {
        return this.fallbackPartitionNum;
    }

    public void setFallbackPartitionNum(Integer fallbackPartitionNum) {
        this.fallbackPartitionNum = fallbackPartitionNum;
    }

    public String toString() {
        try {
            Field[] fields;
            String sb = "";
            Class<?> objClass = this.getClass();
            sb = sb + "Sedona Configuration:\n";
            for (Field field : fields = objClass.getDeclaredFields()) {
                String name = field.getName();
                Object value = field.get(this);
                sb = sb + name + ": " + value.toString() + "\n";
            }
            return sb;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

