/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import java.util.Optional;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.sedona.core.utils.GeomUtils;
import org.apache.spark.sql.sedona_sql.expressions.geohash.GeometryGeoHashEncoder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import scala.Option;

public class Functions {

    public static class ST_BuildArea
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return GeomUtils.buildArea((Geometry)geom);
        }
    }

    public static class ST_XMin
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            Coordinate[] coord = geom.getCoordinates();
            double min = Double.MAX_VALUE;
            for (int i = 0; i < coord.length; ++i) {
                if (!(coord[i].getX() < min)) continue;
                min = coord[i].getX();
            }
            return min;
        }
    }

    public static class ST_XMax
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            Coordinate[] coord = geom.getCoordinates();
            double max = Double.MIN_VALUE;
            for (int i = 0; i < coord.length; ++i) {
                if (!(coord[i].getX() > max)) continue;
                max = coord[i].getX();
            }
            return max;
        }
    }

    public static class ST_IsEmpty
    extends ScalarFunction {
        @DataTypeHint(value="Boolean")
        public boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return geom.isEmpty();
        }
    }

    public static class ST_Force_2D
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return GeomUtils.get2dGeom((Geometry)geom);
        }
    }

    public static class ST_AsEWKT
    extends ScalarFunction {
        @DataTypeHint(value="String")
        public String eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return GeomUtils.getEWKT((Geometry)geom);
        }
    }

    public static class ST_ExteriorRing
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geometry = (Geometry)o;
            return GeomUtils.getExteriorRing((Geometry)geometry);
        }
    }

    public static class ST_PointN
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, int n) {
            if (!(o instanceof LineString)) {
                return null;
            }
            LineString lineString = (LineString)o;
            return GeomUtils.getNthPoint((LineString)lineString, (int)n);
        }
    }

    public static class ST_Reverse
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            return geom.reverse();
        }
    }

    public static class ST_PointOnSurface
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            GeomUtils.getInteriorPoint((Geometry)geom);
            return geom;
        }
    }

    public static class ST_GeoHash
    extends ScalarFunction {
        @DataTypeHint(value="RAW")
        public Optional<String> eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object geometry, Integer precision) {
            Geometry geom = (Geometry)geometry;
            Option geoHash = GeometryGeoHashEncoder.calculate((Geometry)geom, (int)precision);
            if (geoHash.isDefined()) {
                return Optional.of(geoHash.get());
            }
            return Optional.empty();
        }
    }

    public static class ST_FlipCoordinates
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            GeomUtils.flipCoordinates((Geometry)geom);
            return geom;
        }
    }

    public static class ST_Transform
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o, @DataTypeHint(value="String") String sourceCRS, @DataTypeHint(value="String") String targetCRS) {
            Geometry geom = (Geometry)o;
            try {
                CoordinateReferenceSystem sourceCRScode = CRS.decode((String)sourceCRS);
                CoordinateReferenceSystem targetCRScode = CRS.decode((String)targetCRS);
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRScode, (CoordinateReferenceSystem)targetCRScode);
                geom = JTS.transform((Geometry)geom, (MathTransform)transform);
            }
            catch (FactoryException | TransformException e) {
                e.printStackTrace();
            }
            return geom;
        }
    }

    public static class ST_YMax
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            Coordinate[] points = geom.getCoordinates();
            double max = Double.MIN_VALUE;
            for (int i = 0; i < points.length; ++i) {
                max = Math.max(points[i].getY(), max);
            }
            return max;
        }
    }

    public static class ST_YMin
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o) {
            Geometry geom = (Geometry)o;
            Coordinate[] points = geom.getCoordinates();
            double min = Double.MAX_VALUE;
            for (int i = 0; i < points.length; ++i) {
                min = Math.min(points[i].getY(), min);
            }
            return min;
        }
    }

    public static class ST_Distance
    extends ScalarFunction {
        @DataTypeHint(value="Double")
        public Double eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.distance(geom2);
        }
    }

    public static class ST_Buffer
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(Object o, @DataTypeHint(value="Double") Double radius) {
            Geometry geom = (Geometry)o;
            return geom.buffer(radius.doubleValue());
        }
    }
}

