/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.joinJudgement.JudgementBase;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.locationtech.jts.geom.Geometry;

public class NestedLoopJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase
implements FlatMapFunction2<Iterator<T>, Iterator<U>, Pair<U, T>>,
Serializable {
    private static final Logger log = LogManager.getLogger(NestedLoopJudgement.class);

    public NestedLoopJudgement(boolean considerBoundaryIntersection, @Nullable DedupParams dedupParams) {
        super(considerBoundaryIntersection, dedupParams);
    }

    public Iterator<Pair<U, T>> call(Iterator<T> iteratorObject, Iterator<U> iteratorWindow) throws Exception {
        if (!iteratorObject.hasNext() || !iteratorWindow.hasNext()) {
            return Collections.emptyIterator();
        }
        this.initPartition();
        ArrayList<Pair> result = new ArrayList<Pair>();
        ArrayList<T> queryObjects = new ArrayList<T>();
        while (iteratorObject.hasNext()) {
            queryObjects.add(iteratorObject.next());
        }
        while (iteratorWindow.hasNext()) {
            Geometry window = (Geometry)iteratorWindow.next();
            for (int i = 0; i < queryObjects.size(); ++i) {
                Geometry object = (Geometry)queryObjects.get(i);
                if (!this.match(window, object)) continue;
                result.add(Pair.of((Object)window, (Object)object));
            }
        }
        return result.iterator();
    }
}

