/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.tracing;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCContext
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MDCContext.class);
    private static final MDCContext EMPTY = MDCContext.builder().build();
    private static final String EMPTY_TO_STRING = "NA";
    public static final String JOB_ID = "ST-JID";
    public static final String PIPELINE_ID = "ST-PID";
    public static final String TASK_ID = "ST-TID";
    private final Long jobId;
    private final Long pipelineId;
    private final Long taskId;

    public static MDCContext of(long jobId) {
        return MDCContext.builder().jobId(jobId).build();
    }

    public static MDCContext of(long jobId, long pipelineId) {
        return MDCContext.builder().jobId(jobId).pipelineId(pipelineId).build();
    }

    public static MDCContext of(long jobId, long pipelineId, long taskId) {
        return MDCContext.builder().jobId(jobId).pipelineId(pipelineId).taskId(taskId).build();
    }

    public static MDCContext current() {
        return MDCContext.builder().jobId(MDC.get((String)JOB_ID) != null ? Long.valueOf(Long.parseLong(MDC.get((String)JOB_ID))) : null).pipelineId(MDC.get((String)PIPELINE_ID) != null ? Long.valueOf(Long.parseLong(MDC.get((String)PIPELINE_ID))) : null).taskId(MDC.get((String)TASK_ID) != null ? Long.valueOf(Long.parseLong(MDC.get((String)TASK_ID))) : null).build();
    }

    public static MDCContext valueOf(String s) {
        if (EMPTY_TO_STRING.equals(s)) {
            return EMPTY;
        }
        String[] arr = s.split("/");
        Long jobId = Long.parseLong(arr[0]);
        Long pipelineId = Long.parseLong(arr[1]);
        Long taskId = Long.parseLong(arr[2]);
        if (pipelineId == 0L || taskId == 0L) {
            return MDCContext.of(jobId);
        }
        return MDCContext.of(jobId, pipelineId, taskId);
    }

    public String toString() {
        if (this.jobId != null) {
            return String.format("%d/%d/%d", this.jobId, this.pipelineId == null ? 0L : this.pipelineId, this.taskId == null ? 0L : this.taskId);
        }
        return EMPTY_TO_STRING;
    }

    public void put() {
        try {
            if (this.jobId != null) {
                MDC.put((String)JOB_ID, (String)String.valueOf(this.jobId));
            }
            if (this.pipelineId != null) {
                MDC.put((String)PIPELINE_ID, (String)String.valueOf(this.pipelineId));
            }
            if (this.taskId != null) {
                MDC.put((String)TASK_ID, (String)String.valueOf(this.taskId));
            }
        }
        catch (Throwable e) {
            log.error("Failed to put MDC context", e);
            throw e;
        }
    }

    public void clear() {
        try {
            MDC.remove((String)JOB_ID);
            MDC.remove((String)PIPELINE_ID);
            MDC.remove((String)TASK_ID);
        }
        catch (Throwable e) {
            log.error("Failed to clear MDC context", e);
            throw e;
        }
    }

    MDCContext(Long jobId, Long pipelineId, Long taskId) {
        this.jobId = jobId;
        this.pipelineId = pipelineId;
        this.taskId = taskId;
    }

    public static MDCContextBuilder builder() {
        return new MDCContextBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDCContext)) {
            return false;
        }
        MDCContext other = (MDCContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$jobId = this.jobId;
        Long other$jobId = other.jobId;
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        Long this$pipelineId = this.pipelineId;
        Long other$pipelineId = other.pipelineId;
        if (this$pipelineId == null ? other$pipelineId != null : !((Object)this$pipelineId).equals(other$pipelineId)) {
            return false;
        }
        Long this$taskId = this.taskId;
        Long other$taskId = other.taskId;
        return !(this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MDCContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $jobId = this.jobId;
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        Long $pipelineId = this.pipelineId;
        result = result * 59 + ($pipelineId == null ? 43 : ((Object)$pipelineId).hashCode());
        Long $taskId = this.taskId;
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        return result;
    }

    public static class MDCContextBuilder {
        private Long jobId;
        private Long pipelineId;
        private Long taskId;

        MDCContextBuilder() {
        }

        public MDCContextBuilder jobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public MDCContextBuilder pipelineId(Long pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public MDCContextBuilder taskId(Long taskId) {
            this.taskId = taskId;
            return this;
        }

        public MDCContext build() {
            return new MDCContext(this.jobId, this.pipelineId, this.taskId);
        }

        public String toString() {
            return "MDCContext.MDCContextBuilder(jobId=" + this.jobId + ", pipelineId=" + this.pipelineId + ", taskId=" + this.taskId + ")";
        }
    }
}

