/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.QueueType;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.apache.seatunnel.engine.common.config.server.TelemetryConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;
import org.apache.seatunnel.engine.common.runtime.ExecutionMode;

public class EngineConfig {
    private int backupCount = (Integer)ServerConfigOptions.BACKUP_COUNT.defaultValue();
    private int printExecutionInfoInterval = (Integer)ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.defaultValue();
    private int printJobMetricsInfoInterval = (Integer)ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL.defaultValue();
    private int jobMetricsBackupInterval = (Integer)ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL.defaultValue();
    private ThreadShareMode taskExecutionThreadShareMode = (ThreadShareMode)((Object)ServerConfigOptions.TASK_EXECUTION_THREAD_SHARE_MODE.defaultValue());
    private SlotServiceConfig slotServiceConfig = (SlotServiceConfig)ServerConfigOptions.SLOT_SERVICE.defaultValue();
    private CheckpointConfig checkpointConfig = (CheckpointConfig)ServerConfigOptions.CHECKPOINT.defaultValue();
    private ConnectorJarStorageConfig connectorJarStorageConfig = (ConnectorJarStorageConfig)ServerConfigOptions.CONNECTOR_JAR_STORAGE_CONFIG.defaultValue();
    private boolean classloaderCacheMode = (Boolean)ServerConfigOptions.CLASSLOADER_CACHE_MODE.defaultValue();
    private QueueType queueType = (QueueType)((Object)ServerConfigOptions.QUEUE_TYPE.defaultValue());
    private int historyJobExpireMinutes = (Integer)ServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES.defaultValue();
    private ClusterRole clusterRole = ClusterRole.MASTER_AND_WORKER;
    private String eventReportHttpApi;
    private Map<String, String> eventReportHttpHeaders = Collections.emptyMap();
    private ExecutionMode mode = ExecutionMode.CLUSTER;
    private TelemetryConfig telemetryConfig = (TelemetryConfig)ServerConfigOptions.TELEMETRY.defaultValue();

    public void setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount((int)newBackupCount, (int)0);
        this.backupCount = newBackupCount;
    }

    public void setPrintExecutionInfoInterval(int printExecutionInfoInterval) {
        Preconditions.checkPositive((double)printExecutionInfoInterval, (String)(ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL + " must be > 0"));
        this.printExecutionInfoInterval = printExecutionInfoInterval;
    }

    public void setPrintJobMetricsInfoInterval(int printJobMetricsInfoInterval) {
        Preconditions.checkPositive((double)printJobMetricsInfoInterval, (String)(ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL + " must be > 0"));
        this.printJobMetricsInfoInterval = printJobMetricsInfoInterval;
    }

    public void setJobMetricsBackupInterval(int jobMetricsBackupInterval) {
        Preconditions.checkPositive((double)jobMetricsBackupInterval, (String)(ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL + " must be > 0"));
        this.jobMetricsBackupInterval = jobMetricsBackupInterval;
    }

    public void setTaskExecutionThreadShareMode(ThreadShareMode taskExecutionThreadShareMode) {
        Preconditions.checkNotNull((Object)((Object)this.queueType));
        this.taskExecutionThreadShareMode = taskExecutionThreadShareMode;
    }

    public void setHistoryJobExpireMinutes(int historyJobExpireMinutes) {
        Preconditions.checkPositive((double)historyJobExpireMinutes, (String)(ServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES + " must be > 0"));
        this.historyJobExpireMinutes = historyJobExpireMinutes;
    }

    public EngineConfig setQueueType(QueueType queueType) {
        Preconditions.checkNotNull((Object)((Object)queueType));
        this.queueType = queueType;
        return this;
    }

    public EngineConfig setEventReportHttpApi(String eventReportHttpApi) {
        this.eventReportHttpApi = eventReportHttpApi;
        return this;
    }

    public EngineConfig setEventReportHttpHeaders(Map<String, String> eventReportHttpHeaders) {
        this.eventReportHttpHeaders = eventReportHttpHeaders;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getPrintExecutionInfoInterval() {
        return this.printExecutionInfoInterval;
    }

    public int getPrintJobMetricsInfoInterval() {
        return this.printJobMetricsInfoInterval;
    }

    public int getJobMetricsBackupInterval() {
        return this.jobMetricsBackupInterval;
    }

    public ThreadShareMode getTaskExecutionThreadShareMode() {
        return this.taskExecutionThreadShareMode;
    }

    public SlotServiceConfig getSlotServiceConfig() {
        return this.slotServiceConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public ConnectorJarStorageConfig getConnectorJarStorageConfig() {
        return this.connectorJarStorageConfig;
    }

    public boolean isClassloaderCacheMode() {
        return this.classloaderCacheMode;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public int getHistoryJobExpireMinutes() {
        return this.historyJobExpireMinutes;
    }

    public ClusterRole getClusterRole() {
        return this.clusterRole;
    }

    public String getEventReportHttpApi() {
        return this.eventReportHttpApi;
    }

    public Map<String, String> getEventReportHttpHeaders() {
        return this.eventReportHttpHeaders;
    }

    public ExecutionMode getMode() {
        return this.mode;
    }

    public TelemetryConfig getTelemetryConfig() {
        return this.telemetryConfig;
    }

    public void setSlotServiceConfig(SlotServiceConfig slotServiceConfig) {
        this.slotServiceConfig = slotServiceConfig;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public void setConnectorJarStorageConfig(ConnectorJarStorageConfig connectorJarStorageConfig) {
        this.connectorJarStorageConfig = connectorJarStorageConfig;
    }

    public void setClassloaderCacheMode(boolean classloaderCacheMode) {
        this.classloaderCacheMode = classloaderCacheMode;
    }

    public void setClusterRole(ClusterRole clusterRole) {
        this.clusterRole = clusterRole;
    }

    public void setMode(ExecutionMode mode) {
        this.mode = mode;
    }

    public void setTelemetryConfig(TelemetryConfig telemetryConfig) {
        this.telemetryConfig = telemetryConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBackupCount() != other.getBackupCount()) {
            return false;
        }
        if (this.getPrintExecutionInfoInterval() != other.getPrintExecutionInfoInterval()) {
            return false;
        }
        if (this.getPrintJobMetricsInfoInterval() != other.getPrintJobMetricsInfoInterval()) {
            return false;
        }
        if (this.getJobMetricsBackupInterval() != other.getJobMetricsBackupInterval()) {
            return false;
        }
        if (this.isClassloaderCacheMode() != other.isClassloaderCacheMode()) {
            return false;
        }
        if (this.getHistoryJobExpireMinutes() != other.getHistoryJobExpireMinutes()) {
            return false;
        }
        ThreadShareMode this$taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        ThreadShareMode other$taskExecutionThreadShareMode = other.getTaskExecutionThreadShareMode();
        if (this$taskExecutionThreadShareMode == null ? other$taskExecutionThreadShareMode != null : !((Object)((Object)this$taskExecutionThreadShareMode)).equals((Object)other$taskExecutionThreadShareMode)) {
            return false;
        }
        SlotServiceConfig this$slotServiceConfig = this.getSlotServiceConfig();
        SlotServiceConfig other$slotServiceConfig = other.getSlotServiceConfig();
        if (this$slotServiceConfig == null ? other$slotServiceConfig != null : !((Object)this$slotServiceConfig).equals(other$slotServiceConfig)) {
            return false;
        }
        CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
        CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
        if (this$checkpointConfig == null ? other$checkpointConfig != null : !((Object)this$checkpointConfig).equals(other$checkpointConfig)) {
            return false;
        }
        ConnectorJarStorageConfig this$connectorJarStorageConfig = this.getConnectorJarStorageConfig();
        ConnectorJarStorageConfig other$connectorJarStorageConfig = other.getConnectorJarStorageConfig();
        if (this$connectorJarStorageConfig == null ? other$connectorJarStorageConfig != null : !((Object)this$connectorJarStorageConfig).equals(other$connectorJarStorageConfig)) {
            return false;
        }
        QueueType this$queueType = this.getQueueType();
        QueueType other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !((Object)((Object)this$queueType)).equals((Object)other$queueType)) {
            return false;
        }
        ClusterRole this$clusterRole = this.getClusterRole();
        ClusterRole other$clusterRole = other.getClusterRole();
        if (this$clusterRole == null ? other$clusterRole != null : !((Object)((Object)this$clusterRole)).equals((Object)other$clusterRole)) {
            return false;
        }
        String this$eventReportHttpApi = this.getEventReportHttpApi();
        String other$eventReportHttpApi = other.getEventReportHttpApi();
        if (this$eventReportHttpApi == null ? other$eventReportHttpApi != null : !this$eventReportHttpApi.equals(other$eventReportHttpApi)) {
            return false;
        }
        Map<String, String> this$eventReportHttpHeaders = this.getEventReportHttpHeaders();
        Map<String, String> other$eventReportHttpHeaders = other.getEventReportHttpHeaders();
        if (this$eventReportHttpHeaders == null ? other$eventReportHttpHeaders != null : !((Object)this$eventReportHttpHeaders).equals(other$eventReportHttpHeaders)) {
            return false;
        }
        ExecutionMode this$mode = this.getMode();
        ExecutionMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        TelemetryConfig this$telemetryConfig = this.getTelemetryConfig();
        TelemetryConfig other$telemetryConfig = other.getTelemetryConfig();
        return !(this$telemetryConfig == null ? other$telemetryConfig != null : !((Object)this$telemetryConfig).equals(other$telemetryConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBackupCount();
        result = result * 59 + this.getPrintExecutionInfoInterval();
        result = result * 59 + this.getPrintJobMetricsInfoInterval();
        result = result * 59 + this.getJobMetricsBackupInterval();
        result = result * 59 + (this.isClassloaderCacheMode() ? 79 : 97);
        result = result * 59 + this.getHistoryJobExpireMinutes();
        ThreadShareMode $taskExecutionThreadShareMode = this.getTaskExecutionThreadShareMode();
        result = result * 59 + ($taskExecutionThreadShareMode == null ? 43 : ((Object)((Object)$taskExecutionThreadShareMode)).hashCode());
        SlotServiceConfig $slotServiceConfig = this.getSlotServiceConfig();
        result = result * 59 + ($slotServiceConfig == null ? 43 : ((Object)$slotServiceConfig).hashCode());
        CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
        result = result * 59 + ($checkpointConfig == null ? 43 : ((Object)$checkpointConfig).hashCode());
        ConnectorJarStorageConfig $connectorJarStorageConfig = this.getConnectorJarStorageConfig();
        result = result * 59 + ($connectorJarStorageConfig == null ? 43 : ((Object)$connectorJarStorageConfig).hashCode());
        QueueType $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : ((Object)((Object)$queueType)).hashCode());
        ClusterRole $clusterRole = this.getClusterRole();
        result = result * 59 + ($clusterRole == null ? 43 : ((Object)((Object)$clusterRole)).hashCode());
        String $eventReportHttpApi = this.getEventReportHttpApi();
        result = result * 59 + ($eventReportHttpApi == null ? 43 : $eventReportHttpApi.hashCode());
        Map<String, String> $eventReportHttpHeaders = this.getEventReportHttpHeaders();
        result = result * 59 + ($eventReportHttpHeaders == null ? 43 : ((Object)$eventReportHttpHeaders).hashCode());
        ExecutionMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        TelemetryConfig $telemetryConfig = this.getTelemetryConfig();
        result = result * 59 + ($telemetryConfig == null ? 43 : ((Object)$telemetryConfig).hashCode());
        return result;
    }

    public String toString() {
        return "EngineConfig(backupCount=" + this.getBackupCount() + ", printExecutionInfoInterval=" + this.getPrintExecutionInfoInterval() + ", printJobMetricsInfoInterval=" + this.getPrintJobMetricsInfoInterval() + ", jobMetricsBackupInterval=" + this.getJobMetricsBackupInterval() + ", taskExecutionThreadShareMode=" + (Object)((Object)this.getTaskExecutionThreadShareMode()) + ", slotServiceConfig=" + this.getSlotServiceConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ", connectorJarStorageConfig=" + this.getConnectorJarStorageConfig() + ", classloaderCacheMode=" + this.isClassloaderCacheMode() + ", queueType=" + (Object)((Object)this.getQueueType()) + ", historyJobExpireMinutes=" + this.getHistoryJobExpireMinutes() + ", clusterRole=" + (Object)((Object)this.getClusterRole()) + ", eventReportHttpApi=" + this.getEventReportHttpApi() + ", eventReportHttpHeaders=" + this.getEventReportHttpHeaders() + ", mode=" + (Object)((Object)this.getMode()) + ", telemetryConfig=" + this.getTelemetryConfig() + ")";
    }

    public static enum ClusterRole {
        MASTER_AND_WORKER,
        MASTER,
        WORKER;

    }
}

