/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.serializer.protobuf;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.engine.serializer.api.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoStuffSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(ProtoStuffSerializer.class);
    private static final Map<Class<?>, Schema<?>> SCHEMA_CACHE = new ConcurrentHashMap();
    private static final Set<Class<?>> WRAPPERS = new HashSet();
    private static final Class<SerializerDeserializerWrapper> WRAPPER_CLASS = SerializerDeserializerWrapper.class;
    private static final Schema<SerializerDeserializerWrapper> WRAPPER_SCHEMA = ProtoStuffSerializer.getSchema(WRAPPER_CLASS);

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        System.setProperty("protostuff.runtime.preserve_null_elements", "true");
        return SCHEMA_CACHE.computeIfAbsent(clazz, RuntimeSchema::createFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] serialize(T obj) {
        byte[] data;
        Class<?> clazz = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        Object schema = WRAPPER_SCHEMA;
        if (WRAPPERS.contains(clazz)) {
            obj = SerializerDeserializerWrapper.of(obj);
        } else {
            schema = ProtoStuffSerializer.getSchema(clazz);
        }
        try {
            data = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        return data;
    }

    public <T> T deserialize(byte[] data, Class<T> clz) {
        if (!WRAPPERS.contains(clz)) {
            Schema<T> schema = ProtoStuffSerializer.getSchema(clz);
            Object message = schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)message, schema);
            return (T)message;
        }
        SerializerDeserializerWrapper wrapper = new SerializerDeserializerWrapper();
        ProtostuffIOUtil.mergeFrom((byte[])data, wrapper, WRAPPER_SCHEMA);
        return wrapper.getObj();
    }

    static {
        WRAPPERS.add(Boolean.class);
        WRAPPERS.add(Byte.class);
        WRAPPERS.add(Character.class);
        WRAPPERS.add(Short.class);
        WRAPPERS.add(Integer.class);
        WRAPPERS.add(Long.class);
        WRAPPERS.add(Float.class);
        WRAPPERS.add(Double.class);
        WRAPPERS.add(String.class);
        WRAPPERS.add(Void.class);
        WRAPPERS.add(List.class);
        WRAPPERS.add(ArrayList.class);
        WRAPPERS.add(Map.class);
        WRAPPERS.add(HashMap.class);
        WRAPPERS.add(TreeMap.class);
        WRAPPERS.add(Hashtable.class);
        WRAPPERS.add(SortedMap.class);
        WRAPPERS.add(Long[].class);
        WRAPPERS.add(Boolean[].class);
        WRAPPERS.add(Byte[].class);
        WRAPPERS.add(Character[].class);
        WRAPPERS.add(Short[].class);
        WRAPPERS.add(Integer[].class);
        WRAPPERS.add(Float[].class);
        WRAPPERS.add(Double[].class);
        WRAPPERS.add(String[].class);
    }

    public static class SerializerDeserializerWrapper<T> {
        private T obj;

        public static <T> SerializerDeserializerWrapper<T> of(T obj) {
            SerializerDeserializerWrapper<T> wrapper = new SerializerDeserializerWrapper<T>();
            wrapper.setObj(obj);
            return wrapper;
        }

        public T getObj() {
            return this.obj;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }
    }
}

