/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum ProtocolType {
    MEMBER(0, 1, "HZC"),
    CLIENT(1, 1, "CP2"),
    WAN(2, Integer.MAX_VALUE, "HZC"),
    REST(3, 1, "HTTP"),
    MEMCACHE(4, 1, "Memcached");

    private static final Set<ProtocolType> PROTOCOL_TYPES_SET;
    private static final ProtocolType[] PROTOCOL_TYPES;
    private final int id;
    private final int serverSocketCardinality;
    private final String descriptor;

    private ProtocolType(int id, int serverSocketCardinality, String descriptor) {
        this.id = id;
        this.serverSocketCardinality = serverSocketCardinality;
        this.descriptor = descriptor;
    }

    public static ProtocolType valueOf(int ordinal) {
        return PROTOCOL_TYPES[ordinal];
    }

    public static Set<ProtocolType> valuesAsSet() {
        return PROTOCOL_TYPES_SET;
    }

    public int getServerSocketCardinality() {
        return this.serverSocketCardinality;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getId() {
        return this.id;
    }

    public static ProtocolType getById(int id) {
        for (ProtocolType type : ProtocolType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return null;
    }

    static {
        EnumSet<ProtocolType> allProtocolTypes = EnumSet.allOf(ProtocolType.class);
        PROTOCOL_TYPES_SET = Collections.unmodifiableSet(allProtocolTypes);
        PROTOCOL_TYPES = ProtocolType.values();
    }
}

