/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;

abstract class PartitionSpecificClientProxy
extends ClientProxy {
    private int partitionId;

    protected PartitionSpecificClientProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    protected void onInitialize() {
        String partitionKey = StringPartitioningStrategy.getPartitionKey(this.name);
        this.partitionId = this.getContext().getPartitionService().getPartitionId(partitionKey);
    }

    protected ClientMessage invokeOnPartition(ClientMessage req) {
        return (ClientMessage)this.invokeOnPartition(req, this.partitionId);
    }

    protected <T> T invokeOnPartitionInterruptibly(ClientMessage clientMessage) throws InterruptedException {
        return this.invokeOnPartitionInterruptibly(clientMessage, this.partitionId);
    }

    protected <T> ClientDelegatingFuture<T> invokeOnPartitionAsync(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), this.partitionId).invoke();
            return new ClientDelegatingFuture(future, this.getSerializationService(), clientMessageDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected <T> T invokeOnPartition(ClientMessage clientMessage, long invocationTimeoutSeconds) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), this.partitionId);
            clientInvocation.setInvocationTimeoutMillis(invocationTimeoutSeconds);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected <T> T invokeOnPartitionInterruptibly(ClientMessage clientMessage, long invocationTimeoutSeconds) throws InterruptedException {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), this.partitionId);
            clientInvocation.setInvocationTimeoutMillis(invocationTimeoutSeconds);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrowAllowInterrupted(e);
        }
    }
}

