/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.abc.EntryOrderedStore;
import org.apache.royale.abc.Pool;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.ExceptionInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.Metadata;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.abc.semantics.ScriptInfo;
import org.apache.royale.abc.semantics.Trait;
import org.apache.royale.abc.semantics.Traits;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.IMetadataVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.IScriptVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;

public class PoolingABCVisitor
implements IABCVisitor {
    private int majorVersion;
    private int minorVersion;
    private final Pool<Name> namePool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<String> stringPool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<Integer> intPool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<Long> uintPool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<Double> doublePool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<Namespace> nsPool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<Nsset> nssetPool = new Pool(Pool.DefaultType.HasDefaultZero);
    private final Pool<Metadata> metadataPool = new Pool(Pool.DefaultType.NoDefaultZero);
    private List<ScriptInfo> scriptInfos = new ArrayList<ScriptInfo>();
    private List<MethodBodyInfo> methodBodies = new ArrayList<MethodBodyInfo>();
    private EntryOrderedStore<MethodInfo> methodInfos = new EntryOrderedStore();
    private List<ClassVisitor> definedClasses = new ArrayList<ClassVisitor>();
    private Map<MethodInfo, MethodBodyInfo> methodMap = new HashMap<MethodInfo, MethodBodyInfo>();

    @Override
    public void visit(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    @Override
    public IScriptVisitor visitScript() {
        return new ScriptVisitor();
    }

    @Override
    public IClassVisitor visitClass(InstanceInfo iinfo, ClassInfo cinfo) {
        return new ClassVisitor(iinfo, cinfo);
    }

    @Override
    public IMethodVisitor visitMethod(MethodInfo minfo) {
        return new MethodVisitor(minfo);
    }

    @Override
    public void visitPooledDouble(Double d) {
        this.doublePool.add(d);
    }

    @Override
    public void visitPooledInt(Integer i) {
        this.intPool.add(i);
    }

    @Override
    public void visitPooledMetadata(Metadata md) {
        this.metadataPool.add(md);
    }

    @Override
    public void visitPooledName(Name n) {
        this.namePool.add(n);
    }

    @Override
    public void visitPooledNamespace(Namespace ns) {
        this.nsPool.add(ns);
        if (ns != null) {
            this.visitPooledString(ns.getVersionedName());
        }
    }

    @Override
    public void visitPooledNsSet(Nsset nss) {
        this.nssetPool.add(nss);
        if (nss != null) {
            for (Namespace ns : nss) {
                this.visitPooledNamespace(ns);
            }
        }
    }

    @Override
    public void visitPooledString(String s) {
        this.stringPool.add(s);
    }

    @Override
    public void visitPooledUInt(Long l) {
        this.uintPool.add(l);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Pool<Name> getNamePool() {
        return this.namePool;
    }

    public Pool<String> getStringPool() {
        return this.stringPool;
    }

    public Pool<Integer> getIntPool() {
        return this.intPool;
    }

    public Pool<Long> getUintPool() {
        return this.uintPool;
    }

    public Pool<Double> getDoublePool() {
        return this.doublePool;
    }

    public Pool<Namespace> getNsPool() {
        return this.nsPool;
    }

    public Pool<Nsset> getNssetPool() {
        return this.nssetPool;
    }

    public Pool<Metadata> getMetadataPool() {
        return this.metadataPool;
    }

    public List<ScriptInfo> getScriptInfos() {
        return this.scriptInfos;
    }

    public List<MethodBodyInfo> getMethodBodies() {
        return this.methodBodies;
    }

    public EntryOrderedStore<MethodInfo> getMethodInfos() {
        return this.methodInfos;
    }

    public List<ClassVisitor> getDefinedClasses() {
        return this.definedClasses;
    }

    protected int getClassId(ClassInfo info) {
        int id_index = 0;
        for (ClassVisitor candidate : this.definedClasses) {
            if (candidate.classInfo == info) {
                return id_index;
            }
            ++id_index;
        }
        throw new IllegalArgumentException("Unable to find ClassInfo index for " + info);
    }

    protected MethodBodyInfo getMethodBodyForMethodInfo(MethodInfo mi) {
        return this.methodMap.get(mi);
    }

    @Override
    public void visitEnd() {
    }

    private class MethodVisitor
    implements IMethodVisitor {
        final MethodInfo mi;

        MethodVisitor(MethodInfo mi) {
            assert (mi != null);
            this.mi = mi;
        }

        @Override
        public void visit() {
            PoolingABCVisitor.this.methodInfos.add(this.mi);
        }

        @Override
        public IMethodBodyVisitor visitBody(MethodBodyInfo mbi) {
            return new MethodBodyVisitor(mbi);
        }

        @Override
        public void visitEnd() {
        }
    }

    private class MethodBodyVisitor
    implements IMethodBodyVisitor {
        MethodBodyInfo mbi;

        MethodBodyVisitor(MethodBodyInfo mbinfo) {
            this.mbi = mbinfo;
        }

        @Override
        public void visit() {
        }

        @Override
        public void visitEnd() {
            PoolingABCVisitor.this.methodBodies.add(this.mbi);
            PoolingABCVisitor.this.methodMap.put(this.mbi.getMethodInfo(), this.mbi);
        }

        @Override
        public void visitInstruction(int opcode) {
            this.mbi.insn(opcode);
        }

        @Override
        public void visitInstruction(int opcode, int immediate_operand) {
            this.mbi.insn(opcode, immediate_operand);
        }

        @Override
        public void visitInstruction(int opcode, Object single_operand) {
            this.mbi.insn(opcode, single_operand);
        }

        @Override
        public void visitInstruction(int opcode, Object[] operands) {
            this.mbi.insn(opcode, operands);
        }

        @Override
        public void visitInstruction(Instruction insn) {
            this.mbi.insn(insn);
        }

        @Override
        public ITraitsVisitor visitTraits() {
            return new TraitsVisitor(this.mbi.getTraits());
        }

        @Override
        public int visitException(Label from, Label to, Label target, Name ex_type, Name ex_var) {
            return this.mbi.addExceptionInfo(new ExceptionInfo(from, to, target, ex_type, ex_var));
        }

        @Override
        public void visitInstructionList(InstructionList new_list) {
            this.mbi.setInstructionList(new_list);
        }

        @Override
        public void labelCurrent(Label l) {
            this.mbi.labelCurrent(l);
        }

        @Override
        public void labelNext(Label l) {
            this.mbi.labelNext(l);
        }
    }

    private class TraitVisitor
    implements ITraitVisitor {
        Trait t;

        TraitVisitor(Trait t) {
            this.t = t;
        }

        @Override
        public IMetadataVisitor visitMetadata(int count) {
            return new IMetadataVisitor(){

                @Override
                public void visit(Metadata md) {
                    TraitVisitor.this.t.addMetadata(md);
                }
            };
        }

        @Override
        public void visitAttribute(String attr_name, Object attr_value) {
            this.t.addAttr(attr_name, attr_value);
        }

        @Override
        public void visitStart() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private class TraitsVisitor
    implements ITraitsVisitor {
        Traits traits;

        TraitsVisitor(Traits traits) {
            this.traits = traits;
        }

        @Override
        public ITraitVisitor visitClassTrait(int kind, Name name, int slot_id, ClassInfo clazz) {
            Trait t = this.createTrait(kind, name);
            if (slot_id != 0) {
                t.addAttr("slot_id", slot_id);
            }
            t.addAttr("class_id", clazz);
            return new TraitVisitor(t);
        }

        @Override
        public ITraitVisitor visitMethodTrait(int kind, Name name, int dispId, MethodInfo method) {
            Trait t = this.createTrait(kind, name);
            t.addAttr("method_id", method);
            if (dispId != 0) {
                t.addAttr("disp_id", dispId);
            }
            return new TraitVisitor(t);
        }

        @Override
        public ITraitVisitor visitSlotTrait(int kind, Name name, int slotId, Name slotType, Object slotValue) {
            Trait t = this.createTrait(kind, name);
            t.addAttr("slot_id", slotId);
            t.addAttr("type", slotType);
            t.addAttr("value", slotValue);
            if (slotType != null) {
                PoolingABCVisitor.this.visitPooledName(slotType);
            }
            return new TraitVisitor(t);
        }

        @Override
        public void visit() {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public Traits getTraits() {
            return this.traits;
        }

        private Trait createTrait(int kind, Name name) {
            Trait t = new Trait(kind, name);
            this.traits.add(t);
            return t;
        }
    }

    protected class ClassVisitor
    implements IClassVisitor {
        ClassInfo classInfo;
        Traits classTraits;
        InstanceInfo instanceInfo;
        Traits instanceTraits;

        ClassVisitor(InstanceInfo iinfo, ClassInfo cinfo) {
            this.classInfo = cinfo;
            if (null == cinfo.classTraits) {
                cinfo.classTraits = new Traits();
            }
            this.classTraits = cinfo.classTraits;
            this.instanceInfo = iinfo;
            if (null == iinfo.traits) {
                iinfo.traits = new Traits();
            }
            this.instanceTraits = iinfo.traits;
            if (null == iinfo.interfaceNames) {
                iinfo.interfaceNames = new Name[0];
            }
        }

        @Override
        public void visit() {
        }

        @Override
        public ITraitsVisitor visitClassTraits() {
            return new TraitsVisitor(this.classTraits);
        }

        @Override
        public ITraitsVisitor visitInstanceTraits() {
            return new TraitsVisitor(this.instanceTraits);
        }

        @Override
        public void visitEnd() {
            PoolingABCVisitor.this.definedClasses.add(this);
        }

        public InstanceInfo getInstanceInfo() {
            return this.instanceInfo;
        }
    }

    private class ScriptVisitor
    implements IScriptVisitor {
        final ScriptInfo si = new ScriptInfo();

        ScriptVisitor() {
        }

        @Override
        public void visit() {
        }

        @Override
        public void visitEnd() {
            PoolingABCVisitor.this.scriptInfos.add(this.si);
        }

        @Override
        public void visitInit(MethodInfo init_method) {
            this.si.setInit(init_method);
        }

        @Override
        public ITraitsVisitor visitTraits() {
            return new TraitsVisitor(this.si.getTraits());
        }
    }
}

