/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class URLEncoder {
    public static final String charset = "UTF8";

    private URLEncoder() {
    }

    public static final String encode(String string) {
        try {
            return URLEncoder.encode(string, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(charset);
        }
    }

    public static final String encode(String string, String string2) throws UnsupportedEncodingException {
        if (!URLEncoder.needsEncoding(string)) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2));
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 32) {
                if (n2 == 32) {
                    n2 = 43;
                }
                URLEncoder.toHex(stringBuilder, byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.reset();
                stringBuilder.append((char)n2);
                continue;
            }
            try {
                char c;
                bufferedWriter.write(n2);
                if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = string.charAt(i + 1)) >= '\udc00' && c <= '\udfff') {
                    bufferedWriter.write(c);
                    ++i;
                }
                bufferedWriter.flush();
                continue;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(string);
            }
        }
        URLEncoder.toHex(stringBuilder, byteArrayOutputStream.toByteArray());
        return stringBuilder.toString();
    }

    private static final void toHex(StringBuilder stringBuilder, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append('%');
            char c = Character.forDigit(byArray[i] >> 4 & 0xF, 16);
            if (Character.isLetter(c)) {
                c = (char)(c - 32);
            }
            stringBuilder.append(c);
            c = Character.forDigit(byArray[i] & 0xF, 16);
            if (Character.isLetter(c)) {
                c = (char)(c - 32);
            }
            stringBuilder.append(c);
        }
    }

    private static final boolean needsEncoding(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return true;
        }
        return false;
    }
}

