/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public abstract class ToolsConfiguration
extends Configuration {
    private VirtualFile licenseFile;
    protected String output;
    private boolean warnings = true;
    private String dumpConfigFile = null;

    public VirtualFile getLicenseFile() {
        return this.licenseFile;
    }

    private void processDeprecatedOptions(ConfigurationBuffer configurationBuffer) {
        Iterator<String> i = configurationBuffer.getVarIterator();
        while (i.hasNext()) {
            CompilerMessage.CompilerWarning warning;
            String var = i.next();
            ConfigurationInfo info = configurationBuffer.getInfo(var);
            if (info.isDeprecated() && configurationBuffer.getVar(var) != null && (warning = info.getDeprecatedMessage()) == null) continue;
        }
    }

    public String getOutput() {
        return this.output;
    }

    protected abstract String getTargetFile();

    private String createOutputDirectory(ConfigurationBuffer configurationBuffer, String directory) {
        Object result = directory;
        String parent = configurationBuffer.getToken("com.adobe.flex.default.output.directory");
        if (parent == null) {
            String output = this.getOutput();
            if (output != null) {
                parent = new File(output).getParent();
            } else {
                String targetFile = this.getTargetFile();
                if (targetFile != null) {
                    parent = new File(targetFile).getParent();
                }
            }
        }
        if (parent != null) {
            result = parent + File.separatorChar + directory;
        }
        return result;
    }

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        this.processDeprecatedOptions(configurationBuffer);
        boolean strict = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.strict"));
        boolean as3 = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.as3"));
        boolean es = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.es"));
        if (as3 && es || !as3 && !es) {
            throw new BadAS3ESCombination(as3, es);
        }
        if (!strict || es) {
            // empty if block
        }
        CompilerConfiguration compilerConfiguration = this.getCompilerConfiguration();
        this.validateKeepGeneratedSignatures(configurationBuffer, compilerConfiguration);
        this.validateKeepGeneratedActionScript(configurationBuffer, compilerConfiguration);
        this.validateDumpConfig(configurationBuffer);
    }

    private void validateDumpConfig(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
    }

    private void validateKeepGeneratedSignatures(ConfigurationBuffer configurationBuffer, CompilerConfiguration compilerConfiguration) throws ConfigurationException {
    }

    private void validateKeepGeneratedActionScript(ConfigurationBuffer configurationBuffer, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.keepGeneratedActionScript()) {
            String dir = compilerConfiguration.getGeneratedDirectory();
            if (dir == null) {
                dir = this.createOutputDirectory(configurationBuffer, "generated");
            } else if (!new File(dir).isAbsolute()) {
                dir = this.createOutputDirectory(configurationBuffer, dir);
            }
            assert (dir != null);
            if (dir != null) {
                File file = new File(dir);
                file.mkdirs();
                try {
                    compilerConfiguration.setGeneratedDirectory(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getWarnings() {
        return this.warnings;
    }

    public void cfgWarnings(ConfigurationValue cv, boolean b) {
        this.warnings = b;
    }

    public static ConfigurationInfo getWarningsInfo() {
        return new ConfigurationInfo();
    }

    public String getDumpConfig() {
        return this.dumpConfigFile;
    }

    public void cfgDumpConfig(ConfigurationValue cv, String filename) {
        this.dumpConfigFile = Configuration.getOutputPath(cv, filename);
    }

    public static ConfigurationInfo getDumpConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            @Override
            public boolean isAdvanced() {
                return true;
            }

            @Override
            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public static class BadAS3ESCombination
    extends ConfigurationException {
        private static final long serialVersionUID = 4418178171352281793L;
        public final boolean as3;
        public final boolean es;

        public BadAS3ESCombination(boolean as3, boolean es) {
            super("");
            this.as3 = as3;
            this.es = es;
        }
    }

    public static class BadESStrictCombination
    extends ConfigurationException {
        private static final long serialVersionUID = 384624904213418743L;
        public final boolean es;
        public final boolean strict;

        public BadESStrictCombination(boolean es, boolean strict) {
            super("");
            this.es = es;
            this.strict = strict;
        }

        @Override
        public String getLevel() {
            return "warning";
        }
    }

    public static class DeprecatedConfigurationOption
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 5523004100027677184L;
        public final String var;
        public final String replacement;
        public final String since;

        public DeprecatedConfigurationOption(String var, String replacement, String since) {
            this.var = var;
            this.replacement = replacement;
            this.since = since;
        }
    }
}

