/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.caches;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.royale.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.royale.compiler.internal.mxml.MXMLData;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTokenizer;

public class MXMLDataCache
extends ConcurrentCacheStoreBase<MXMLData> {
    public static MXMLDataCacheKey createKey(IFileSpecification fileSpec) {
        return new MXMLDataCacheKey(fileSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MXMLData createEntryValue(CacheStoreKeyBase key) {
        IFileSpecification fileSpec = ((MXMLDataCacheKey)key).fileSpec;
        MXMLTokenizer tokenizer = new MXMLTokenizer(fileSpec);
        try {
            List<MXMLToken> tokens = tokenizer.parseTokens(fileSpec.createReader());
            MXMLData mxmlData = new MXMLData(tokens, tokenizer.getPrefixMap(), fileSpec);
            if (tokenizer.hasTokenizationProblems()) {
                mxmlData.getProblems().addAll(tokenizer.getTokenizationProblems());
            }
            MXMLData mXMLData = mxmlData;
            return mXMLData;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            MXMLData mXMLData = null;
            return mXMLData;
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }

    private static class MXMLDataCacheKey
    extends CacheStoreKeyBase {
        private IFileSpecification fileSpec;

        public MXMLDataCacheKey(IFileSpecification fileSpec) {
            assert (fileSpec != null);
            this.fileSpec = fileSpec;
        }

        @Override
        public String generateKey() {
            return String.valueOf(this.fileSpec.isOpenDocument()) + ":" + this.fileSpec.getPath();
        }
    }
}

