/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.tools.ToolsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ApplicationCompilerConfiguration
extends ToolsConfiguration {
    private List<String> fileSpecs = new ArrayList<String>();
    private String resourceModulePath;
    private boolean generateLinkReport;
    private boolean generateSizeReport;
    private List resourceBundles = new LinkedList();
    private VirtualFile configFile;
    private VirtualFile projector;

    public static Map<String, String> getAliases() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(Configuration.getAliases());
        map.remove("o");
        return map;
    }

    @Override
    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        super.validate(cfgbuf);
        String targetFile = this.getTargetFile();
        if (targetFile == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cfgval) {
        try {
            return ConfigurationPathResolver.getVirtualFile(file, this.configResolver, cfgval);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    public List<String> getFileSpecs() {
        return this.fileSpecs;
    }

    public void cfgFileSpecs(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.fileSpecs.addAll(args);
    }

    public static ConfigurationInfo getFileSpecsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }

            @Override
            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public String getOutput() {
        return this.getTargetFile();
    }

    @Override
    public String getTargetFile() {
        if (this.fileSpecs.size() == 0 && this.getIncludeResourceBundles().size() > 0) {
            if (this.resourceModulePath == null) {
                // empty if block
            }
            return this.resourceModulePath;
        }
        return this.fileSpecs.size() > 0 ? this.fileSpecs.get(this.fileSpecs.size() - 1) : null;
    }

    @Override
    public boolean generateLinkReport() {
        return this.generateLinkReport || super.generateLinkReport();
    }

    public void keepLinkReport(boolean b) {
        this.generateLinkReport = b;
    }

    @Override
    public boolean generateSizeReport() {
        return this.generateSizeReport || super.generateSizeReport();
    }

    public void keepSizeReport(boolean b) {
        this.generateSizeReport = b;
    }

    public List getIncludeResourceBundles() {
        return this.resourceBundles;
    }

    public void cfgIncludeResourceBundles(ConfigurationValue val, List includeResourceBundles) {
        this.resourceBundles.addAll(this.toQNameString(includeResourceBundles));
    }

    public static ConfigurationInfo getIncludeResourceBundlesInfo() {
        return new ConfigurationInfo(-1, new String[]{"bundle"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getLoadConfig() {
        return this.configFile;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = ConfigurationPathResolver.getVirtualFile(filename, this.configResolver, cv);
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            @Override
            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getProjector() {
        return this.projector;
    }

    public void cfgProjector(ConfigurationValue cfgval, String path) {
        this.projector = this.getVirtualFile(path, cfgval);
    }

    public static ConfigurationInfo getProjectorInfo() {
        return new ConfigurationInfo(){

            @Override
            public boolean isHidden() {
                return true;
            }
        };
    }
}

