/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.apache.royale.test.ant.IRoyaleUnitServer;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.tools.ant.BuildException;

public class RoyaleUnitSocketServer
implements IRoyaleUnitServer {
    private static final char NULL_BYTE = '\u0000';
    private static final String POLICY_FILE_REQUEST = "<policy-file-request/>";
    private static final String DOMAIN_POLICY = "<?xml version=\"1.0\"?><cross-domain-policy xmlns=\"http://localhost\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.adobe.com/xml/schemas PolicyFileSocket.xsd\"><allow-access-from domain=\"*\" to-ports=\"{0}\" /></cross-domain-policy>";
    private static final String START_OF_TEST_RUN_ACK = "<startOfTestRunAck/>";
    private static final String END_OF_TEST_RUN_ACK = "<endOfTestRunAck/>";
    private int port;
    private int timeout;
    private int inboundBufferSize;
    private boolean waitForPolicyFile;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private InputStreamReader inboundReader = null;
    private OutputStreamWriter outboundWriter = null;

    public RoyaleUnitSocketServer(int port, int timeout, int inboundBufferSize, boolean waitForPolicyFile) {
        this.port = port;
        this.timeout = timeout;
        this.inboundBufferSize = inboundBufferSize;
        this.waitForPolicyFile = waitForPolicyFile;
    }

    @Override
    public void start() throws IOException {
        LoggingUtil.log("Starting server ...");
        try {
            this.openServerSocket();
            this.openClientSocket();
            this.prepareClientSocket();
        }
        catch (SocketTimeoutException e) {
            throw new BuildException("Socket timeout waiting for royaleunit report", (Throwable)e);
        }
    }

    @Override
    public boolean isPending() {
        return false;
    }

    @Override
    public Exception getException() {
        return null;
    }

    private void resetInboundStream() throws IOException {
        LoggingUtil.log("Resetting client connection ...");
        this.closeClientSocket();
        this.openClientSocket();
    }

    private void openServerSocket() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.serverSocket.setSoTimeout(this.timeout);
        LoggingUtil.log("Opening server socket on port [" + this.port + "].");
    }

    private void openClientSocket() throws IOException {
        LoggingUtil.log("Waiting for client connection ...");
        this.clientSocket = this.serverSocket.accept();
        LoggingUtil.log("Client connected.");
        LoggingUtil.log("Setting inbound buffer size to [" + this.inboundBufferSize + "] bytes.");
        this.inboundReader = new InputStreamReader((InputStream)new BufferedInputStream(this.clientSocket.getInputStream(), this.inboundBufferSize), "UTF-8");
        this.outboundWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.clientSocket.getOutputStream()), "UTF-8");
        LoggingUtil.log("Receiving data ...");
    }

    private void prepareClientSocket() throws IOException {
        String request;
        if (this.waitForPolicyFile && (request = this.readNextTokenFromSocket()).equals(POLICY_FILE_REQUEST)) {
            LoggingUtil.log("Policy file requested.");
            this.sendPolicyFile();
            this.resetInboundStream();
        }
        this.sendTestRunStartAcknowledgement();
    }

    private void sendPolicyFile() throws IOException {
        this.sendOutboundMessage(MessageFormat.format(DOMAIN_POLICY, Integer.toString(this.port)));
        LoggingUtil.log("Policy file sent.");
    }

    private void sendTestRunStartAcknowledgement() throws IOException {
        LoggingUtil.log("Sending acknowledgement to player to start sending test data ...\n");
        this.sendOutboundMessage(START_OF_TEST_RUN_ACK);
    }

    @Override
    public String readNextTokenFromSocket() throws IOException {
        StringBuffer buffer = new StringBuffer();
        int piece = -1;
        while ((piece = this.inboundReader.read()) != 0) {
            if (piece == -1) {
                return null;
            }
            char chr = (char)piece;
            buffer.append(chr);
        }
        String token = buffer.toString();
        return token;
    }

    private void sendOutboundMessage(String message) throws IOException {
        if (this.outboundWriter != null) {
            this.outboundWriter.write(message);
            this.outboundWriter.write(0);
            this.outboundWriter.flush();
        }
    }

    @Override
    public void stop() throws IOException, InterruptedException {
        LoggingUtil.log("\nStopping server ...");
        this.sendTestRunEndAcknowledgement();
        this.closeClientSocket();
        this.closeServerSocket();
    }

    private void sendTestRunEndAcknowledgement() throws IOException {
        LoggingUtil.log("End of test data reached, sending acknowledgement to player ...");
        this.sendOutboundMessage(END_OF_TEST_RUN_ACK);
    }

    private void closeClientSocket() throws IOException {
        LoggingUtil.log("Closing client connection ...");
        if (this.outboundWriter != null) {
            this.outboundWriter.close();
        }
        if (this.inboundReader != null) {
            this.inboundReader.close();
        }
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
    }

    private void closeServerSocket() throws IOException {
        LoggingUtil.log("Closing server on port [" + this.port + "] ...");
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }
}

