/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.starter;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.util.HostInfo;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.exporter.MqttExporter;
import org.springframework.stereotype.Component;

@Component
public class ExporterServer {
    private static final HostInfo HOST_INFO = HostInfo.getInstall();
    private static final String NAMESPACE = "mqtt";
    @Resource
    private ConnectConf connectConf;
    private MqttExporter mqttExporter;

    @PostConstruct
    public void init() throws Exception {
        if (this.connectConf.isEnablePrometheus()) {
            this.mqttExporter = new MqttExporter(NAMESPACE, HOST_INFO.getName(), HOST_INFO.getAddress(), this.connectConf.getExporterPort(), this.connectConf.isExportJvmInfo());
            this.mqttExporter.start();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.mqttExporter != null) {
            this.mqttExporter.shutdown();
        }
    }
}

