/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.cs.channel.ChannelCloseFrom;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class ConnectHandler
extends ChannelInboundHandlerAdapter {
    private static Logger logger = LoggerFactory.getLogger(ConnectHandler.class);
    private final List<String> simpleExceptions = Collections.singletonList("Connection reset by peer");
    @Resource
    private ChannelManager channelManager;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
        this.channelManager.addChannel(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.channelManager.closeConnect(ctx.channel(), ChannelCloseFrom.CLIENT, "be closed");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause.getMessage() == null || !this.simpleExceptions.contains(cause.getMessage())) {
            logger.error("exceptionCaught {}", (Object)ctx.channel(), (Object)cause);
        }
        this.channelManager.closeConnect(ctx.channel(), ChannelCloseFrom.SERVER, cause.getMessage());
    }
}

