/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft.processor;

import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.meta.raft.MqttRaftServer;
import org.apache.rocketmq.mqtt.meta.raft.MqttStateMachine;
import org.apache.rocketmq.mqtt.meta.raft.processor.StateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WillMsgStateProcessor
extends StateProcessor {
    private static Logger logger = LoggerFactory.getLogger(WillMsgStateProcessor.class);
    private MqttRaftServer server;

    public WillMsgStateProcessor(MqttRaftServer server) {
        this.server = server;
    }

    @Override
    public Response onReadRequest(ReadRequest request) throws Exception {
        try {
            MqttStateMachine sm = this.server.getMqttStateMachine(request.getGroup());
            if (sm == null) {
                logger.error("Fail to process will ReadRequest , Not Found SM for {}", (Object)request.getGroup());
                return null;
            }
            String operation = request.getOperation();
            String key = request.getKey();
            if ("get".equals(operation)) {
                return this.get(sm.getRocksDBEngine(), key.getBytes());
            }
            if ("scan".equals(operation)) {
                String startKey = (String)request.getExtDataMap().get("startKey");
                String endKey = (String)request.getExtDataMap().get("endKey");
                return this.scan(sm.getRocksDBEngine(), startKey.getBytes(), endKey.getBytes());
            }
        }
        catch (Exception e) {
            if (request.getKey() == null) {
                logger.error("Fail to delete, startKey {}, endKey {}", new Object[]{request.getExtDataMap().get("startKey"), request.getExtDataMap().get("endKey"), e});
            } else {
                logger.error("Fail to process will ReadRequest, k {}", (Object)request.getKey(), (Object)e);
            }
            throw e;
        }
        return null;
    }

    @Override
    public Response onWriteRequest(WriteRequest log) throws Exception {
        try {
            MqttStateMachine sm = this.server.getMqttStateMachine(log.getGroup());
            if (sm == null) {
                logger.error("Fail to process will WriteRequest , Not Found SM for {}", (Object)log.getGroup());
                return null;
            }
            String operation = log.getOperation();
            String key = log.getKey();
            byte[] value = log.getData().toByteArray();
            if ("put".equals(operation)) {
                return this.put(sm.getRocksDBEngine(), key.getBytes(), value);
            }
            if ("delete".equals(operation)) {
                return this.delete(sm.getRocksDBEngine(), key.getBytes());
            }
            if ("compareAndPut".equals(operation)) {
                String expectValue = (String)log.getExtDataMap().get("expectValue");
                if ("NOT_FOUND".equals(expectValue)) {
                    return this.compareAndPut(sm.getRocksDBEngine(), key.getBytes(), null, value);
                }
                return this.compareAndPut(sm.getRocksDBEngine(), key.getBytes(), ((String)log.getExtDataMap().get("expectValue")).getBytes(), value);
            }
        }
        catch (Exception e) {
            logger.error("Fail to process will WriteRequest, k {}", (Object)log.getKey(), (Object)e);
            throw e;
        }
        return null;
    }

    @Override
    public String groupCategory() {
        return "willMsg";
    }
}

