/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.rocketmq.common.MixAll;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class MetaConf {
    private static final String CONF_FILE_NAME = "meta.conf";
    private File confFile;
    private String clusterName = "defaultCluster";
    private String allNodeAddress;
    private String dbPath = System.getProperty("user.home") + "/mqtt_meta/db";
    private String raftDataPath = System.getProperty("user.home") + "/mqtt_meta/raft";
    private int metaPort = 25000;
    private String selfAddress;
    private String membersAddress;
    private int maxRetainedTopicNum = 10000;
    private int electionTimeoutMs = 1000;
    private int snapshotIntervalSecs = 60000;
    private String raftServiceName = System.getenv("RaftServiceName");

    public MetaConf() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(CONF_FILE_NAME);
        InputStream in = classPathResource.getInputStream();
        Properties properties = new Properties();
        properties.load(in);
        in.close();
        MixAll.properties2Object((Properties)properties, (Object)this);
        this.confFile = new File(classPathResource.getURL().getFile());
    }

    public File getConfFile() {
        return this.confFile;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getAllNodeAddress() {
        return this.allNodeAddress;
    }

    public void setAllNodeAddress(String allNodeAddress) {
        this.allNodeAddress = allNodeAddress;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    public String getRaftDataPath() {
        return this.raftDataPath;
    }

    public void setRaftDataPath(String raftDataPath) {
        this.raftDataPath = raftDataPath;
    }

    public int getMetaPort() {
        return this.metaPort;
    }

    public void setMetaPort(int metaPort) {
        this.metaPort = metaPort;
    }

    public String getSelfAddress() {
        return this.selfAddress;
    }

    public void setSelfAddress(String selfAddress) {
        this.selfAddress = selfAddress;
    }

    public String getMembersAddress() {
        return this.membersAddress;
    }

    public void setMembersAddress(String membersAddress) {
        this.membersAddress = membersAddress;
    }

    public int getElectionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    public void setElectionTimeoutMs(int electionTimeoutMs) {
        this.electionTimeoutMs = electionTimeoutMs;
    }

    public int getSnapshotIntervalSecs() {
        return this.snapshotIntervalSecs;
    }

    public void setSnapshotIntervalSecs(int snapshotIntervalSecs) {
        this.snapshotIntervalSecs = snapshotIntervalSecs;
    }

    public int getMaxRetainedTopicNum() {
        return this.maxRetainedTopicNum;
    }

    public void setMaxRetainedTopicNum(int maxRetainedTopicNum) {
        this.maxRetainedTopicNum = maxRetainedTopicNum;
    }

    public String getRaftServiceName() {
        return this.raftServiceName;
    }

    public void setRaftServiceName(String raftServiceName) {
        this.raftServiceName = raftServiceName;
    }
}

