/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.upstream.processor;

import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.facade.SubscriptionPersistManager;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.common.model.MqttTopic;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.util.SpringUtils;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.ds.meta.FirstTopicManager;
import org.apache.rocketmq.mqtt.ds.upstream.UpstreamProcessor;
import org.springframework.stereotype.Component;

@Component
public class UnSubscribeProcessor
implements UpstreamProcessor {
    @Resource
    private FirstTopicManager firstTopicManager;
    private SubscriptionPersistManager subscriptionPersistManager;

    @Override
    public CompletableFuture<HookResult> process(MqttMessageUpContext context, MqttMessage message) {
        MqttUnsubscribePayload payload = (MqttUnsubscribePayload)message.payload();
        if (payload.topics() != null && !payload.topics().isEmpty()) {
            HashSet<Subscription> subscriptions = new HashSet<Subscription>();
            for (String topic : payload.topics()) {
                String topicFilter = TopicUtils.normalizeTopic((String)topic);
                MqttTopic mqttTopic = TopicUtils.decode((String)topicFilter);
                this.firstTopicManager.checkFirstTopicIfCreated(mqttTopic.getFirstTopic());
                Subscription subscription = new Subscription();
                subscription.setTopicFilter(topicFilter);
                subscriptions.add(subscription);
            }
            if (this.subscriptionPersistManager == null) {
                this.subscriptionPersistManager = (SubscriptionPersistManager)SpringUtils.getBean(SubscriptionPersistManager.class);
            }
            if (this.subscriptionPersistManager != null) {
                this.subscriptionPersistManager.removeSubscriptions(context.getClientId(), subscriptions);
            }
        }
        return HookResult.newHookResult((int)200, null, null);
    }
}

