/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.store;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.CommunicationMode;
import org.apache.rocketmq.client.impl.FindBrokerResult;
import org.apache.rocketmq.client.impl.consumer.PullAPIWrapper;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.mqtt.common.facade.LmqQueueStore;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.QueueOffset;
import org.apache.rocketmq.mqtt.common.model.StoreResult;
import org.apache.rocketmq.mqtt.common.util.NamespaceUtil;
import org.apache.rocketmq.mqtt.common.util.StatUtil;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.meta.FirstTopicManager;
import org.apache.rocketmq.mqtt.ds.mq.MqFactory;
import org.apache.rocketmq.mqtt.exporter.collector.MqttMetricsCollector;
import org.apache.rocketmq.mqtt.exporter.exception.PrometheusException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LmqQueueStoreManager
implements LmqQueueStore {
    private static Logger logger = LoggerFactory.getLogger(LmqQueueStoreManager.class);
    private PullAPIWrapper pullAPIWrapper;
    private DefaultMQPullConsumer defaultMQPullConsumer;
    private DefaultMQProducer defaultMQProducer;
    private String consumerGroup = "CID_RMQ_SYS_LMQ_PULL";
    private Map<String, Set<String>> topic2Brokers = new ConcurrentHashMap<String, Set<String>>();
    @Resource
    private ServiceConf serviceConf;
    @Resource
    private FirstTopicManager firstTopicManager;

    @PostConstruct
    public void init() throws MQClientException {
        this.defaultMQPullConsumer = MqFactory.buildDefaultMQPullConsumer(this.consumerGroup, this.serviceConf.getProperties());
        this.defaultMQPullConsumer.setConsumerPullTimeoutMillis(2000L);
        this.defaultMQPullConsumer.start();
        this.pullAPIWrapper = this.defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getPullAPIWrapper();
        this.defaultMQProducer = MqFactory.buildDefaultMQProducer("GID_LMQ_SEND", this.serviceConf.getProperties());
        this.defaultMQProducer.setRetryTimesWhenSendAsyncFailed(0);
        this.defaultMQProducer.start();
    }

    private org.apache.rocketmq.common.message.Message toMQMessage(Message finalMessage) {
        Message message = finalMessage.copy();
        org.apache.rocketmq.common.message.Message mqMessage = new org.apache.rocketmq.common.message.Message(finalMessage.getFirstTopic(), message.getPayload());
        MessageAccessor.putProperty((org.apache.rocketmq.common.message.Message)mqMessage, (String)"UNIQ_KEY", (String)message.getMsgId());
        mqMessage.putUserProperty("originMqttTopic", message.getOriginTopic());
        mqMessage.putUserProperty("IS_EMPTY_MSG", String.valueOf(message.isEmpty()));
        if (message.getUserProperty(Message.extPropertyQoS) != null) {
            mqMessage.putUserProperty("qosLevel", message.getUserProperty(Message.extPropertyQoS));
        }
        if (message.getUserProperty(Message.extPropertyCleanSessionFlag) != null) {
            mqMessage.putUserProperty("cleanSessionFlag", message.getUserProperty(Message.extPropertyCleanSessionFlag));
        }
        if (message.getUserProperty(Message.extPropertyClientId) != null) {
            mqMessage.putUserProperty("clientId", NamespaceUtil.decodeOriginResource((String)message.getUserProperty(Message.extPropertyClientId)));
            message.clearUserProperty(Message.extPropertyClientId);
        }
        mqMessage.putUserProperty("retryTimes", String.valueOf(message.getRetry()));
        Map userProps = message.getUserProperties();
        if (userProps != null && !userProps.isEmpty()) {
            mqMessage.putUserProperty("extData", JSONObject.toJSONString((Object)userProps));
        }
        return mqMessage;
    }

    private Message toLmqMessage(Queue queue, MessageExt mqMessage) {
        Message message = new Message();
        message.setMsgId(mqMessage.getMsgId());
        message.setOffset(this.parseLmqOffset(queue, mqMessage));
        message.setEmpty(Boolean.parseBoolean(mqMessage.getUserProperty("IS_EMPTY_MSG")));
        if (StringUtils.isNotBlank((CharSequence)mqMessage.getUserProperty("originMqttTopic"))) {
            message.setOriginTopic(mqMessage.getUserProperty("originMqttTopic"));
        } else if (StringUtils.isNotBlank((CharSequence)mqMessage.getUserProperty("INNER_MULTI_DISPATCH"))) {
            String[] lmqSet;
            String s = mqMessage.getUserProperty("INNER_MULTI_DISPATCH");
            for (String lmq : lmqSet = s.split(",")) {
                if (TopicUtils.isWildCard((String)lmq)) continue;
                String originQueue = lmq.replace("%LMQ%", "");
                message.setOriginTopic(StringUtils.replace((String)originQueue, (String)"%", (String)"/"));
            }
        }
        message.setFirstTopic(mqMessage.getTopic());
        message.setPayload(mqMessage.getBody());
        message.setStoreTimestamp(mqMessage.getStoreTimestamp());
        message.setBornTimestamp(mqMessage.getBornTimestamp());
        if (StringUtils.isNotBlank((CharSequence)mqMessage.getUserProperty("retryTimes"))) {
            message.setRetry(Integer.parseInt(mqMessage.getUserProperty("retryTimes")));
        }
        if (StringUtils.isNotBlank((CharSequence)mqMessage.getUserProperty("extData"))) {
            message.getUserProperties().putAll((Map)JSONObject.parseObject((String)mqMessage.getUserProperty("extData"), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]));
        }
        return message;
    }

    private long parseLmqOffset(Queue queue, MessageExt mqMessage) {
        String multiDispatchQueue = mqMessage.getProperty("INNER_MULTI_DISPATCH");
        if (StringUtils.isBlank((CharSequence)multiDispatchQueue)) {
            return mqMessage.getQueueOffset();
        }
        String multiQueueOffset = mqMessage.getProperty("INNER_MULTI_QUEUE_OFFSET");
        if (StringUtils.isBlank((CharSequence)multiQueueOffset)) {
            return mqMessage.getQueueOffset();
        }
        String[] queues = multiDispatchQueue.split(",");
        String[] queueOffsets = multiQueueOffset.split(",");
        for (int i = 0; i < queues.length; ++i) {
            if (!("%LMQ%" + StringUtils.replace((String)queue.getQueueName(), (String)"/", (String)"%")).equals(queues[i])) continue;
            return Long.parseLong(queueOffsets[i]);
        }
        return mqMessage.getQueueOffset();
    }

    public CompletableFuture<StoreResult> putMessage(Set<String> queues, Message message) {
        final CompletableFuture<StoreResult> result = new CompletableFuture<StoreResult>();
        org.apache.rocketmq.common.message.Message mqMessage = this.toMQMessage(message);
        mqMessage.setTags("MQTT_COMMON");
        mqMessage.putUserProperty("INNER_MULTI_DISPATCH", StringUtils.join((Iterable)queues.stream().map(s -> "%LMQ%" + StringUtils.replace((String)s, (String)"/", (String)"%")).collect(Collectors.toSet()), (String)","));
        try {
            final long start = System.currentTimeMillis();
            this.defaultMQProducer.send(mqMessage, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    result.complete(LmqQueueStoreManager.this.toStoreResult(sendResult));
                    long rt = System.currentTimeMillis() - start;
                    StatUtil.addInvoke((String)"lmqWrite", (long)rt);
                    LmqQueueStoreManager.this.collectLmqReadWriteMatchActionRt("lmqWrite", rt, true);
                }

                public void onException(Throwable e) {
                    logger.error("", e);
                    result.completeExceptionally(e);
                    long rt = System.currentTimeMillis() - start;
                    StatUtil.addInvoke((String)"lmqWrite", (long)rt, (boolean)false);
                    LmqQueueStoreManager.this.collectLmqReadWriteMatchActionRt("lmqWrite", rt, false);
                }
            });
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private void collectLmqReadWriteMatchActionRt(String action, long rt, boolean status) {
        try {
            MqttMetricsCollector.collectLmqReadWriteMatchActionRt((long)rt, (String[])new String[]{action, String.valueOf(status)});
        }
        catch (PrometheusException e) {
            logger.error("", (Throwable)e);
        }
    }

    public CompletableFuture<org.apache.rocketmq.mqtt.common.model.PullResult> pullMessage(String firstTopic, final Queue queue, QueueOffset queueOffset, long count) {
        final CompletableFuture<org.apache.rocketmq.mqtt.common.model.PullResult> result = new CompletableFuture<org.apache.rocketmq.mqtt.common.model.PullResult>();
        try {
            MessageQueue messageQueue = new MessageQueue(firstTopic, queue.getBrokerName(), (int)queue.getQueueId());
            final long start = System.currentTimeMillis();
            String lmqTopic = "%LMQ%" + StringUtils.replace((String)queue.getQueueName(), (String)"/", (String)"%");
            this.pull(lmqTopic, messageQueue, queueOffset.getOffset(), (int)count, new PullCallback(){

                public void onSuccess(PullResult pullResult) {
                    result.complete(LmqQueueStoreManager.this.toLmqPullResult(queue, pullResult));
                    long rt = System.currentTimeMillis() - start;
                    StatUtil.addInvoke((String)"lmqPull", (long)rt);
                    LmqQueueStoreManager.this.collectLmqReadWriteMatchActionRt("lmqPull", rt, true);
                    StatUtil.addPv((String)pullResult.getPullStatus().name(), (long)1L);
                    try {
                        MqttMetricsCollector.collectPullStatusTps((long)1L, (String[])new String[]{pullResult.getPullStatus().name()});
                    }
                    catch (Throwable e) {
                        logger.error("collect prometheus error", e);
                    }
                }

                public void onException(Throwable e) {
                    logger.error("", e);
                    result.completeExceptionally(e);
                    long rt = System.currentTimeMillis() - start;
                    StatUtil.addInvoke((String)"lmqPull", (long)rt, (boolean)false);
                    LmqQueueStoreManager.this.collectLmqReadWriteMatchActionRt("lmqPull", rt, false);
                }
            });
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    public CompletableFuture<org.apache.rocketmq.mqtt.common.model.PullResult> pullLastMessages(String firstTopic, Queue queue, long count) {
        CompletableFuture<Long> maxResult = this.queryQueueMaxOffset(queue);
        return maxResult.thenCompose(maxId -> {
            long begin = maxId - count;
            if (begin < 0L) {
                begin = 0L;
            }
            QueueOffset queueOffset = new QueueOffset();
            queueOffset.setOffset(begin);
            return this.pullMessage(firstTopic, queue, queueOffset, count);
        });
    }

    public CompletableFuture<Long> queryQueueMaxOffset(Queue queue) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.maxOffset(queue);
            }
            catch (MQClientException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Set<String> getReadableBrokers(String firstTopic) {
        return this.firstTopicManager.getReadableBrokers(firstTopic);
    }

    public String getClientRetryTopic() {
        return this.serviceConf.getClientRetryTopic();
    }

    public String getClientP2pTopic() {
        return this.serviceConf.getClientP2pTopic();
    }

    private StoreResult toStoreResult(SendResult sendResult) {
        StoreResult storeResult = new StoreResult();
        Queue queue = new Queue();
        queue.setQueueId((long)sendResult.getMessageQueue().getQueueId());
        queue.setBrokerName(sendResult.getMessageQueue().getBrokerName());
        storeResult.setQueue(queue);
        storeResult.setMsgId(sendResult.getMsgId());
        return storeResult;
    }

    private org.apache.rocketmq.mqtt.common.model.PullResult toLmqPullResult(Queue queue, PullResult pullResult) {
        org.apache.rocketmq.mqtt.common.model.PullResult lmqPullResult = new org.apache.rocketmq.mqtt.common.model.PullResult();
        if (PullStatus.OFFSET_ILLEGAL.equals((Object)pullResult.getPullStatus())) {
            lmqPullResult.setCode(302);
            QueueOffset nextQueueOffset = new QueueOffset();
            nextQueueOffset.setOffset(pullResult.getNextBeginOffset());
            lmqPullResult.setNextQueueOffset(nextQueueOffset);
        } else {
            lmqPullResult.setCode(301);
        }
        List messageExtList = pullResult.getMsgFoundList();
        if (messageExtList != null && !messageExtList.isEmpty()) {
            ArrayList<Message> messageList = new ArrayList<Message>(messageExtList.size());
            for (MessageExt messageExt : messageExtList) {
                Message lmqMessage = this.toLmqMessage(queue, messageExt);
                messageList.add(lmqMessage);
            }
            lmqPullResult.setMessageList(messageList);
        }
        return lmqPullResult;
    }

    private void pull(String lmqTopic, final MessageQueue mq, long offset, int maxNums, final PullCallback pullCallback) throws MQClientException, RemotingException, InterruptedException {
        try {
            int sysFlag = PullSysFlag.buildSysFlag((boolean)false, (boolean)false, (boolean)true, (boolean)false);
            long timeoutMillis = 3000L;
            this.pullKernelImpl(lmqTopic, mq, "*", "TAG", 0L, offset, maxNums, sysFlag, 0L, 5000L, timeoutMillis, CommunicationMode.ASYNC, new PullCallback(){

                public void onSuccess(PullResult pullResult) {
                    PullResult userPullResult = LmqQueueStoreManager.this.pullAPIWrapper.processPullResult(mq, pullResult, new SubscriptionData());
                    pullCallback.onSuccess(userPullResult);
                }

                public void onException(Throwable e) {
                    pullCallback.onException(e);
                }
            });
        }
        catch (MQBrokerException e) {
            throw new MQClientException("pullAsync unknow exception", (Throwable)e);
        }
    }

    public PullResult pullKernelImpl(String lmqTopic, MessageQueue mq, String subExpression, String expressionType, long subVersion, long offset, int maxNums, int sysFlag, long commitOffset, long brokerSuspendMaxTimeMillis, long timeoutMillis, CommunicationMode communicationMode, PullCallback pullCallback) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        MQClientInstance mQClientFactory = this.defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory();
        FindBrokerResult findBrokerResult = mQClientFactory.findBrokerAddressInSubscribe(mq.getBrokerName(), this.pullAPIWrapper.recalculatePullFromWhichNode(mq), false);
        if (null == findBrokerResult) {
            mQClientFactory.updateTopicRouteInfoFromNameServer(mq.getTopic());
            findBrokerResult = mQClientFactory.findBrokerAddressInSubscribe(mq.getBrokerName(), this.pullAPIWrapper.recalculatePullFromWhichNode(mq), false);
        }
        if (findBrokerResult != null) {
            if (!ExpressionType.isTagType((String)expressionType) && findBrokerResult.getBrokerVersion() < MQVersion.Version.V4_1_0_SNAPSHOT.ordinal()) {
                throw new MQClientException("The broker[" + mq.getBrokerName() + ", " + findBrokerResult.getBrokerVersion() + "] does not upgrade to support for filter message by " + expressionType, null);
            }
            int sysFlagInner = sysFlag;
            if (findBrokerResult.isSlave()) {
                sysFlagInner = PullSysFlag.clearCommitOffsetFlag((int)sysFlagInner);
            }
            PullMessageRequestHeader requestHeader = new PullMessageRequestHeader();
            requestHeader.setConsumerGroup(this.consumerGroup);
            requestHeader.setTopic(lmqTopic);
            requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
            requestHeader.setQueueOffset(Long.valueOf(offset));
            requestHeader.setMaxMsgNums(Integer.valueOf(maxNums));
            requestHeader.setSysFlag(Integer.valueOf(sysFlagInner));
            requestHeader.setCommitOffset(Long.valueOf(commitOffset));
            requestHeader.setSuspendTimeoutMillis(Long.valueOf(brokerSuspendMaxTimeMillis));
            requestHeader.setSubscription(subExpression);
            requestHeader.setSubVersion(Long.valueOf(subVersion));
            requestHeader.setExpressionType(expressionType);
            String brokerAddr = findBrokerResult.getBrokerAddr();
            PullResult pullResult = mQClientFactory.getMQClientAPIImpl().pullMessage(brokerAddr, requestHeader, timeoutMillis, communicationMode, pullCallback);
            return pullResult;
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    private long maxOffset(Queue queue) throws MQClientException {
        String lmqTopic = "%LMQ%" + StringUtils.replace((String)queue.getQueueName(), (String)"/", (String)"%");
        MQClientInstance mQClientFactory = this.defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory();
        String brokerAddr = mQClientFactory.findBrokerAddressInPublish(queue.getBrokerName());
        if (null == brokerAddr) {
            mQClientFactory.updateTopicRouteInfoFromNameServer(queue.toFirstTopic());
            brokerAddr = mQClientFactory.findBrokerAddressInPublish(queue.getBrokerName());
        }
        if (brokerAddr != null) {
            try {
                return mQClientFactory.getMQClientAPIImpl().getMaxOffset(brokerAddr, lmqTopic, (int)queue.getQueueId(), 3000L);
            }
            catch (Exception e) {
                throw new MQClientException("Invoke Broker[" + brokerAddr + "] exception", (Throwable)e);
            }
        }
        throw new MQClientException("The broker[" + queue.getBrokerName() + "] not exist", null);
    }
}

