/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.notify;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.mqtt.common.model.MessageEvent;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.mq.MqFactory;
import org.apache.rocketmq.mqtt.ds.notify.NotifyManager;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NotifyRetryManager {
    private static Logger logger = LoggerFactory.getLogger(NotifyRetryManager.class);
    private DefaultMQPushConsumer defaultMQPushConsumer;
    @Resource
    private NotifyManager notifyManager;
    @Resource
    private ServiceConf serviceConf;

    @PostConstruct
    public void init() throws MQClientException {
        this.defaultMQPushConsumer = MqFactory.buildDefaultMQPushConsumer("CID_RMQ_SYS_notify_retry", this.serviceConf.getProperties(), (MessageListener)new RetryNotify());
        this.defaultMQPushConsumer.subscribe(this.serviceConf.getEventNotifyRetryTopic(), "*");
        this.defaultMQPushConsumer.start();
    }

    private void doRetryNotify(MessageExt messageExt) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        String payload = new String(messageExt.getBody(), StandardCharsets.UTF_8);
        HashSet<MessageEvent> events = new HashSet<MessageEvent>(JSONObject.parseArray((String)payload, MessageEvent.class));
        String node = messageExt.getUserProperty("retryNode");
        String retryTime = messageExt.getUserProperty("retryTime");
        if (StringUtils.isBlank((CharSequence)node)) {
            return;
        }
        if (this.notifyManager.doNotify(node, events)) {
            return;
        }
        this.notifyManager.sendEventRetryMsg(events, 2, node, retryTime != null ? Integer.parseInt(retryTime) : 1);
    }

    class RetryNotify
    implements MessageListenerConcurrently {
        RetryNotify() {
        }

        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
            try {
                for (MessageExt messageExt : msgs) {
                    NotifyRetryManager.this.doRetryNotify(messageExt);
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

