/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.mq;

import java.util.Properties;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.UtilAll;

public class MqProducer {
    private DefaultMQProducer defaultMQProducer = new DefaultMQProducer();

    public MqProducer(Properties properties) {
        this(properties.getProperty("NAMESRV_ADDR"));
    }

    public MqProducer(String nameSrv) {
        this.defaultMQProducer.setNamesrvAddr(nameSrv);
        this.defaultMQProducer.setInstanceName(this.buildInstanceName());
        this.defaultMQProducer.setVipChannelEnabled(false);
    }

    public String buildInstanceName() {
        return Integer.toString(UtilAll.getPid()) + "#" + System.nanoTime();
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    public void setProducerGroup(String producerGroup) {
        this.defaultMQProducer.setProducerGroup(producerGroup);
    }

    public void start() {
        try {
            this.defaultMQProducer.start();
        }
        catch (MQClientException e) {
            throw new RuntimeException(e);
        }
    }
}

