/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.facade.WillMsgPersistManager;
import org.apache.rocketmq.mqtt.ds.meta.WillMsgClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WillMsgPersistManagerImpl
implements WillMsgPersistManager {
    private static Logger logger = LoggerFactory.getLogger(WillMsgPersistManagerImpl.class);
    @Resource
    private WillMsgClient willMsgClient;

    public void init() {
    }

    public CompletableFuture<Boolean> put(String key, String value) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            this.willMsgClient.put(key, value, future);
            return future;
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            logger.error("", (Throwable)e);
            return future;
        }
    }

    public CompletableFuture<Boolean> delete(String key) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            this.willMsgClient.delete(key, future);
            return future;
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            logger.error("", (Throwable)e);
            return future;
        }
    }

    public CompletableFuture<byte[]> get(String key) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        try {
            this.willMsgClient.get(key, future);
            return future;
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            logger.error("", (Throwable)e);
            return future;
        }
    }

    public CompletableFuture<Boolean> compareAndPut(String key, String expectValue, String updateValue) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            this.willMsgClient.compareAndPut(key, expectValue, updateValue, future);
            return future;
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            logger.error("", (Throwable)e);
            return future;
        }
    }

    public CompletableFuture<Map<String, String>> scan(String startKey, String endKey) {
        CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        try {
            this.willMsgClient.scan(startKey, endKey, future);
            return future;
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            logger.error("", (Throwable)e);
            return future;
        }
    }
}

