/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.auth;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.AuthManager;
import org.apache.rocketmq.mqtt.common.hook.AbstractUpstreamHook;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHook;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookEnum;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookManager;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.common.util.HmacSHA1Util;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;

public class AuthManagerSample
extends AbstractUpstreamHook
implements AuthManager {
    @Resource
    private UpstreamHookManager upstreamHookManager;
    @Resource
    private ServiceConf serviceConf;
    public Executor executor;

    public void init() {
        this.executor = new ThreadPoolExecutor(8, 16, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), (ThreadFactory)new ThreadFactoryImpl("AuthHook_"));
        this.register();
    }

    public void register() {
        this.upstreamHookManager.addHook(UpstreamHookEnum.AUTH.ordinal(), (UpstreamHook)this);
    }

    public CompletableFuture<HookResult> processMqttMessage(MqttMessageUpContext context, MqttMessage message) {
        return CompletableFuture.supplyAsync(() -> this.doAuth(message), this.executor);
    }

    public HookResult doAuth(MqttMessage message) {
        if (message instanceof MqttConnectMessage) {
            MqttConnectMessage mqttConnectMessage = (MqttConnectMessage)message;
            MqttConnectPayload mqttConnectPayload = mqttConnectMessage.payload();
            String clientId = mqttConnectPayload.clientIdentifier();
            String username = mqttConnectPayload.userName();
            byte[] password = mqttConnectPayload.passwordInBytes();
            boolean validateSign = false;
            try {
                validateSign = HmacSHA1Util.validateSign((String)clientId, (byte[])password, (String)this.serviceConf.getSecretKey());
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            if (!Objects.equals(username, this.serviceConf.getUsername()) || !validateSign) {
                return new HookResult(-200, (int)MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD.byteValue(), "Auth Failed", null);
            }
        }
        return new HookResult(200, null, null);
    }
}

